/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.actionsupport.DeleteFromRelationConfirmationDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> toDelete;
    private final Map<OsmPrimitive, PrimitiveData> clonedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();

    public DeleteCommand(Collection<? extends OsmPrimitive> data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be empty");
        }
        if (data.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection"));
        }
        this.toDelete = data;
    }

    public DeleteCommand(OsmPrimitive data) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.toDelete = Collections.singleton(data);
    }

    public DeleteCommand(OsmDataLayer layer, OsmPrimitive data) throws IllegalArgumentException {
        super(layer);
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.toDelete = Collections.singleton(data);
    }

    public DeleteCommand(OsmDataLayer layer, Collection<? extends OsmPrimitive> data) throws IllegalArgumentException {
        super(layer);
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be empty");
        }
        if (data.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection"));
        }
        this.toDelete = data;
    }

    @Override
    public boolean executeCommand() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive.isDeleted()) {
                throw new IllegalArgumentException(osmPrimitive.toString() + " is already deleted");
            }
            this.clonedPrimitives.put(osmPrimitive, osmPrimitive.save());
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).setNodes(null);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ((Relation)osmPrimitive).setMembers(null);
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(false);
        }
        for (Map.Entry entry : this.clonedPrimitives.entrySet()) {
            ((OsmPrimitive)entry.getKey()).load((PrimitiveData)entry.getValue());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JLabel getDescription() {
        void var3_8;
        if (this.toDelete.size() == 1) {
            OsmPrimitive primitive = this.toDelete.iterator().next();
            String msg = "";
            switch (OsmPrimitiveType.from(primitive)) {
                case NODE: {
                    msg = I18n.marktr("Delete node {0}");
                    break;
                }
                case WAY: {
                    msg = I18n.marktr("Delete way {0}");
                    break;
                }
                case RELATION: {
                    msg = I18n.marktr("Delete relation {0}");
                }
            }
            return new JLabel(I18n.tr(msg, primitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(primitive)), 0);
        }
        HashSet<OsmPrimitiveType> typesToDelete = new HashSet<OsmPrimitiveType>();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            typesToDelete.add(OsmPrimitiveType.from(osmPrimitive));
        }
        String msg = "";
        String string = "object";
        if (typesToDelete.size() > 1) {
            msg = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            OsmPrimitiveType t = (OsmPrimitiveType)((Object)typesToDelete.iterator().next());
            String string2 = t.getAPIName();
            switch (t) {
                case NODE: {
                    msg = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case WAY: {
                    msg = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case RELATION: {
                    msg = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                }
            }
        }
        return new JLabel(msg, ImageProvider.get("data", (String)var3_8), 0);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.toDelete.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osmPrimitive : this.toDelete) {
            children.add(new PseudoCommand(){

                @Override
                public JLabel getDescription() {
                    return new JLabel(I18n.tr("Deleted ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0);
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return children;
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toDelete;
    }

    public static Command deleteWithReferences(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean silent) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Set<OsmPrimitive> parents = OsmPrimitive.getReferrer(selection);
        parents.addAll(selection);
        if (parents.isEmpty()) {
            return null;
        }
        if (!DeleteCommand.checkAndConfirmOutlyingDeletes(layer, parents) && !silent) {
            return null;
        }
        return new DeleteCommand(layer, parents);
    }

    public static Command deleteWithReferences(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.deleteWithReferences(layer, selection, false);
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.delete(layer, selection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(OsmDataLayer layer, Collection<OsmPrimitive> primitivesToDelete) {
        HashSet<Node> nodesToDelete = new HashSet<Node>();
        for (Way way : OsmPrimitive.getFilteredList(primitivesToDelete, Way.class)) {
            for (Node n : way.getNodes()) {
                if (n.isTagged()) continue;
                List<OsmPrimitive> referringPrimitives = n.getReferrers();
                referringPrimitives.removeAll(primitivesToDelete);
                int count = 0;
                for (OsmPrimitive p : referringPrimitives) {
                    if (p.isDeleted()) continue;
                    ++count;
                }
                if (count != 0) continue;
                nodesToDelete.add(n);
            }
        }
        return nodesToDelete;
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay) {
        return DeleteCommand.delete(layer, selection, alsoDeleteNodesInWay, false);
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay, boolean silent) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> primitivesToDelete = new HashSet<OsmPrimitive>(selection);
        HashSet<Way> waysToBeChanged = new HashSet<Way>();
        if (alsoDeleteNodesInWay) {
            Collection<Node> nodesToDelete = DeleteCommand.computeNodesToDelete(layer, primitivesToDelete);
            primitivesToDelete.addAll(nodesToDelete);
        }
        if (!silent && !DeleteCommand.checkAndConfirmOutlyingDeletes(layer, primitivesToDelete)) {
            return null;
        }
        waysToBeChanged.addAll(OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(primitivesToDelete), Way.class));
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Way w : waysToBeChanged) {
            Way wnew = new Way(w);
            wnew.removeNodes(primitivesToDelete);
            if (wnew.getNodesCount() < 2) {
                primitivesToDelete.add(w);
                continue;
            }
            cmds.add(new ChangeCommand(w, wnew));
        }
        if (!silent) {
            Set<RelationToChildReference> references = RelationToChildReference.getRelationToChildReferences(primitivesToDelete);
            Iterator<RelationToChildReference> it = references.iterator();
            while (it.hasNext()) {
                RelationToChildReference ref = it.next();
                if (!ref.getParent().isDeleted()) continue;
                it.remove();
            }
            if (!references.isEmpty()) {
                DeleteFromRelationConfirmationDialog dialog = DeleteFromRelationConfirmationDialog.getInstance();
                dialog.getModel().populate(references);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return null;
                }
            }
        }
        for (Relation cur : OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(primitivesToDelete), Relation.class)) {
            Relation rel = new Relation(cur);
            rel.removeMembersFor(primitivesToDelete);
            cmds.add(new ChangeCommand(cur, rel));
        }
        if (!primitivesToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(layer, primitivesToDelete));
        }
        return new SequenceCommand(I18n.tr("Delete"), cmds);
    }

    public static Command deleteWaySegment(OsmDataLayer layer, WaySegment ws) {
        if (ws.way.getNodesCount() < 3) {
            return DeleteCommand.delete(layer, Collections.singleton(ws.way));
        }
        if (ws.way.firstNode() == ws.way.lastNode()) {
            ArrayList<Node> n = new ArrayList<Node>();
            n.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount() - 1));
            n.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
            Way wnew = new Way(ws.way);
            wnew.setNodes(n);
            return new ChangeCommand(ws.way, wnew);
        }
        ArrayList<Node> n1 = new ArrayList<Node>();
        ArrayList<Node> n2 = new ArrayList<Node>();
        n1.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
        n2.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount()));
        Way wnew = new Way(ws.way);
        if (n1.size() < 2) {
            wnew.setNodes(n2);
            return new ChangeCommand(ws.way, wnew);
        }
        if (n2.size() < 2) {
            wnew.setNodes(n1);
            return new ChangeCommand(ws.way, wnew);
        }
        ArrayList<List<Node>> chunks = new ArrayList<List<Node>>(2);
        chunks.add(n1);
        chunks.add(n2);
        return SplitWayAction.splitWay(layer, ws.way, chunks, Collections.emptyList()).getCommand();
    }

    private static boolean checkAndConfirmOutlyingDeletes(OsmDataLayer layer, Collection<OsmPrimitive> primitivesToDelete) {
        JPanel msg;
        Area a = layer.data.getDataSourceArea();
        boolean outside = false;
        boolean incomplete = false;
        if (a != null) {
            for (OsmPrimitive osm : primitivesToDelete) {
                if (osm.isIncomplete()) {
                    incomplete = true;
                    continue;
                }
                if (!(osm instanceof Node) || osm.isNewOrUndeleted() || a.contains(((Node)osm).getCoor())) continue;
                outside = true;
            }
        } else {
            for (OsmPrimitive osm : primitivesToDelete) {
                if (!osm.isIncomplete()) continue;
                incomplete = true;
            }
        }
        if (outside) {
            msg = new JPanel(new GridBagLayout());
            msg.add(new JLabel("<html>" + I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to delete?") + "</html>"));
            boolean answer = ConditionalOptionPaneUtil.showConfirmationDialog("delete_outside_nodes", Main.parent, msg, I18n.tr("Delete confirmation"), 0, 3, 0);
            if (!answer) {
                return false;
            }
        }
        if (incomplete) {
            msg = new JPanel(new GridBagLayout());
            msg.add(new JLabel("<html>" + I18n.tr("You are about to delete incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to delete?") + "</html>"));
            boolean answer = ConditionalOptionPaneUtil.showConfirmationDialog("delete_incomplete", Main.parent, msg, I18n.tr("Delete confirmation"), 0, 3, 0);
            if (!answer) {
                return false;
            }
        }
        return true;
    }
}

