/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceCommand
extends Command {
    private Command[] sequence;
    private boolean sequence_complete;
    private final String name;
    public boolean continueOnError = false;

    public SequenceCommand(String name, Collection<Command> sequenz) {
        this.name = name;
        this.sequence = new Command[sequenz.size()];
        this.sequence = sequenz.toArray(this.sequence);
    }

    public SequenceCommand(String name, Command ... sequenz) {
        this(name, Arrays.asList(sequenz));
    }

    @Override
    public boolean executeCommand() {
        for (int i = 0; i < this.sequence.length; ++i) {
            Command c = this.sequence[i];
            boolean result = c.executeCommand();
            if (!result) {
                Main.debug("SequenceCommand, executing command[" + i + "] " + c + " result: " + result);
            }
            if (result || this.continueOnError) continue;
            this.undoCommands(i - 1);
            return false;
        }
        this.sequence_complete = true;
        return true;
    }

    public Command getLastCommand() {
        if (this.sequence.length == 0) {
            return null;
        }
        return this.sequence[this.sequence.length - 1];
    }

    private void undoCommands(int start) {
        if (!this.sequence_complete) {
            return;
        }
        for (int i = start; i >= 0; --i) {
            this.sequence[i].undoCommand();
        }
    }

    @Override
    public void undoCommand() {
        this.undoCommands(this.sequence.length - 1);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (Command c : this.sequence) {
            c.fillModifiedData(modified, deleted, added);
        }
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.tr("Sequence") + ": " + this.name, ImageProvider.get("data", "sequence"), 0);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList(this.sequence);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<? extends OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        for (Command c : this.sequence) {
            prims.addAll(c.getParticipatingPrimitives());
        }
        return prims;
    }
}

