/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class UndeletePrimitivesCommand
extends ConflictResolveCommand {
    private final List<OsmPrimitive> toUndelete = new ArrayList<OsmPrimitive>();
    private final List<OsmPrimitive> replacedPrimitives = new ArrayList<OsmPrimitive>();

    public UndeletePrimitivesCommand(OsmPrimitive node) {
        this.toUndelete.add(node);
    }

    public UndeletePrimitivesCommand(OsmPrimitive ... toUndelete) {
        for (int i = 0; i < toUndelete.length; ++i) {
            this.toUndelete.add(toUndelete[i]);
        }
    }

    public UndeletePrimitivesCommand(Collection<OsmPrimitive> toUndelete) {
        this.toUndelete.addAll(toUndelete);
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.trn("Undelete {0} primitive", "Undelete {0} primitives", this.toUndelete.size(), this.toUndelete.size()), ImageProvider.get("data", "object"), 0);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.replacedPrimitives.clear();
        for (OsmPrimitive primitive : this.toUndelete) {
            OsmPrimitive prim;
            if (this.getLayer().getConflicts().hasConflictForMy(primitive)) {
                this.rememberConflict(this.getLayer().getConflicts().getConflictForMy(primitive));
                this.getLayer().getConflicts().remove(primitive);
            }
            switch (primitive.getType()) {
                case NODE: {
                    prim = new Node((Node)primitive, true);
                    break;
                }
                case WAY: {
                    prim = new Way((Way)primitive, true);
                    break;
                }
                case RELATION: {
                    prim = new Relation((Relation)primitive, true);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.replacedPrimitives.add(prim);
            this.replacePrimitive(this.getLayer().data, primitive, prim);
        }
        return true;
    }

    private void replacePrimitive(DataSet dataSet, OsmPrimitive oldPrim, OsmPrimitive newPrim) {
        dataSet.addPrimitive(newPrim);
        for (OsmPrimitive referrer : oldPrim.getReferrers()) {
            if (referrer instanceof Way) {
                Way w = (Way)referrer;
                List<Node> nodes = w.getNodes();
                Collections.replaceAll(nodes, (Node)oldPrim, (Node)newPrim);
                w.setNodes(nodes);
                w.setModified(true);
                continue;
            }
            if (!(referrer instanceof Relation)) continue;
            Relation r = (Relation)referrer;
            List<RelationMember> members = r.getMembers();
            ListIterator<RelationMember> it = members.listIterator();
            while (it.hasNext()) {
                RelationMember rm = it.next();
                if (rm.getMember() != oldPrim) continue;
                it.set(new RelationMember(rm.getRole(), newPrim));
            }
            r.setMembers(members);
            r.setModified(true);
        }
        dataSet.removePrimitive(oldPrim);
    }

    @Override
    public void undoCommand() {
        for (int i = 0; i < this.toUndelete.size(); ++i) {
            this.replacePrimitive(this.getLayer().data, this.replacedPrimitives.get(i), this.toUndelete.get(i));
        }
        super.undoCommand();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }
}

