/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class Bounds {
    private double minLat;
    private double minLon;
    private double maxLat;
    private double maxLon;

    public LatLon getMin() {
        return new LatLon(this.minLat, this.minLon);
    }

    public LatLon getMax() {
        return new LatLon(this.maxLat, this.maxLon);
    }

    public Bounds(LatLon min, LatLon max) {
        this(min.lat(), min.lon(), max.lat(), max.lon());
    }

    public Bounds(LatLon b) {
        this(b, b);
    }

    public Bounds(double minlat, double minlon, double maxlat, double maxlon) {
        this.minLat = this.roundToOsmPrecision(minlat);
        this.minLon = this.roundToOsmPrecision(minlon);
        this.maxLat = this.roundToOsmPrecision(maxlat);
        this.maxLon = this.roundToOsmPrecision(maxlon);
    }

    public Bounds(double[] coords) {
        CheckParameterUtil.ensureParameterNotNull(coords, "coords");
        if (coords.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Expected array of length 4, got {0}", coords.length));
        }
        this.minLat = this.roundToOsmPrecision(coords[0]);
        this.minLon = this.roundToOsmPrecision(coords[1]);
        this.maxLat = this.roundToOsmPrecision(coords[2]);
        this.maxLon = this.roundToOsmPrecision(coords[3]);
    }

    public Bounds(String asString, String separator) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(asString, "asString");
        String[] components = asString.split(separator);
        if (components.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Exactly four doubles excpected in string, got {0}", components.length));
        }
        double[] values = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                values[i] = Double.parseDouble(components[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", components[i]));
            }
        }
        if (!LatLon.isValidLat(values[0])) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", values[0]));
        }
        if (!LatLon.isValidLon(values[1])) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", values[1]));
        }
        if (!LatLon.isValidLat(values[2])) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", values[2]));
        }
        if (!LatLon.isValidLon(values[3])) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", values[3]));
        }
        this.minLat = this.roundToOsmPrecision(values[0]);
        this.minLon = this.roundToOsmPrecision(values[1]);
        this.maxLat = this.roundToOsmPrecision(values[2]);
        this.maxLon = this.roundToOsmPrecision(values[3]);
    }

    public Bounds(Bounds other) {
        this(other.getMin(), other.getMax());
    }

    public Bounds(Rectangle2D rect) {
        this(rect.getMinY(), rect.getMinX(), rect.getMaxY(), rect.getMaxX());
    }

    public Bounds(LatLon center, double latExtent, double lonExtent) {
        CheckParameterUtil.ensureParameterNotNull(center, "center");
        if (latExtent <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 exptected, got {1}", "latExtent", latExtent));
        }
        if (lonExtent <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 exptected, got {1}", "lonExtent", lonExtent));
        }
        this.minLat = this.roundToOsmPrecision(center.lat() - latExtent / 2.0);
        this.minLon = this.roundToOsmPrecision(center.lon() - lonExtent / 2.0);
        this.maxLat = this.roundToOsmPrecision(center.lat() + latExtent / 2.0);
        this.maxLon = this.roundToOsmPrecision(center.lon() + lonExtent / 2.0);
    }

    public String toString() {
        return "Bounds[" + this.minLat + "," + this.minLon + "," + this.maxLat + "," + this.maxLon + "]";
    }

    public String toShortString(DecimalFormat format) {
        return format.format(this.minLat) + " " + format.format(this.minLon) + " / " + format.format(this.maxLat) + " " + format.format(this.maxLon);
    }

    public LatLon getCenter() {
        return this.getMin().getCenter(this.getMax());
    }

    public void extend(LatLon ll) {
        if (ll.lat() < this.minLat) {
            this.minLat = this.roundToOsmPrecision(ll.lat());
        }
        if (ll.lon() < this.minLon) {
            this.minLon = this.roundToOsmPrecision(ll.lon());
        }
        if (ll.lat() > this.maxLat) {
            this.maxLat = this.roundToOsmPrecision(ll.lat());
        }
        if (ll.lon() > this.maxLon) {
            this.maxLon = this.roundToOsmPrecision(ll.lon());
        }
    }

    public void extend(Bounds b) {
        this.extend(b.getMin());
        this.extend(b.getMax());
    }

    public boolean contains(LatLon ll) {
        if (ll.lat() < this.minLat || ll.lon() < this.minLon) {
            return false;
        }
        return !(ll.lat() > this.maxLat) && !(ll.lon() > this.maxLon);
    }

    public boolean intersects(Bounds b) {
        return b.getMax().lat() >= this.minLat && b.getMax().lon() >= this.minLon && b.getMin().lat() <= this.maxLat && b.getMin().lon() <= this.maxLon;
    }

    public Rectangle2D.Double asRect() {
        return new Rectangle2D.Double(this.minLon, this.minLat, this.maxLon - this.minLon, this.maxLat - this.minLat);
    }

    public double getArea() {
        return (this.maxLon - this.minLon) * (this.maxLat - this.minLat);
    }

    public String encodeAsString(String separator) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.minLat).append(separator).append(this.minLon).append(separator).append(this.maxLat).append(separator).append(this.maxLon);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bounds other = (Bounds)obj;
        if (Double.doubleToLongBits(this.maxLat) != Double.doubleToLongBits(other.maxLat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLon) != Double.doubleToLongBits(other.maxLon)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLat) != Double.doubleToLongBits(other.minLat)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLon) == Double.doubleToLongBits(other.minLon);
    }

    private double roundToOsmPrecision(double value) {
        return (double)Math.round(value / 1.0E-7) * 1.0E-7;
    }
}

