/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;

public class CachedLatLon
extends LatLon {
    private EastNorth eastNorth;
    private Projection proj;

    public CachedLatLon(double lat, double lon) {
        super(lat, lon);
    }

    public CachedLatLon(LatLon coor) {
        super(coor.lat(), coor.lon());
        this.proj = null;
    }

    public CachedLatLon(EastNorth eastNorth) {
        super(Main.proj.eastNorth2latlon(eastNorth));
        this.proj = Main.proj;
        this.eastNorth = eastNorth;
    }

    public final void setCoor(LatLon coor) {
        this.setLocation(coor.lon(), coor.lat());
        this.proj = null;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.proj = Main.proj;
        this.eastNorth = eastNorth;
        LatLon l = this.proj.eastNorth2latlon(eastNorth);
        this.setLocation(l.lon(), l.lat());
    }

    public final EastNorth getEastNorth() {
        if (this.proj != Main.proj) {
            this.proj = Main.proj;
            this.eastNorth = this.proj.latlon2eastNorth(this);
        }
        return this.eastNorth;
    }

    public String toString() {
        return "CachedLatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    public Projection getProjection() {
        return this.proj;
    }
}

