/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Relation
extends OsmPrimitive {
    private RelationMember[] members = new RelationMember[0];
    private BBox bbox;

    public List<RelationMember> getMembers() {
        return new CopyList<RelationMember>(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(List<RelationMember> members) {
        boolean locked = this.writeLock();
        try {
            for (RelationMember rm : this.members) {
                rm.getMember().removeReferrer(this);
            }
            this.members = members != null ? members.toArray(new RelationMember[members.size()]) : new RelationMember[0];
            for (RelationMember rm : this.members) {
                rm.getMember().addReferrer(this);
            }
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public int getMembersCount() {
        return this.members.length;
    }

    public RelationMember getMember(int index) {
        return this.members[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(RelationMember member) {
        boolean locked = this.writeLock();
        try {
            RelationMember[] newMembers = new RelationMember[this.members.length + 1];
            System.arraycopy(this.members, 0, newMembers, 0, this.members.length);
            newMembers[this.members.length] = member;
            this.members = newMembers;
            member.getMember().addReferrer(this);
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(int index, RelationMember member) {
        boolean locked = this.writeLock();
        try {
            RelationMember[] newMembers = new RelationMember[this.members.length + 1];
            System.arraycopy(this.members, 0, newMembers, 0, index);
            System.arraycopy(this.members, index, newMembers, index + 1, this.members.length - index);
            newMembers[index] = member;
            this.members = newMembers;
            member.getMember().addReferrer(this);
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationMember setMember(int index, RelationMember member) {
        boolean locked = this.writeLock();
        try {
            RelationMember originalMember = this.members[index];
            this.members[index] = member;
            if (originalMember.getMember() != member.getMember()) {
                member.getMember().addReferrer(this);
                originalMember.getMember().removeReferrer(this);
                this.fireMembersChanged();
            }
            RelationMember relationMember = originalMember;
            return relationMember;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationMember removeMember(int index) {
        boolean locked = this.writeLock();
        try {
            List<RelationMember> members = this.getMembers();
            RelationMember result = members.remove(index);
            this.setMembers(members);
            RelationMember relationMember = result;
            return relationMember;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    protected Relation(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Relation() {
        super(0L, false);
    }

    public Relation(Relation clone, boolean clearId) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone);
        if (clearId) {
            this.clearOsmId();
        }
    }

    public Relation(Relation clone) {
        this(clone, false);
    }

    public Relation(long id) throws IllegalArgumentException {
        super(id, false);
    }

    public Relation(long id, int version) {
        super(id, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osm) {
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm);
            this.setMembers(((Relation)osm).getMembers());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData data) {
        boolean locked = this.writeLock();
        try {
            super.load(data);
            RelationData relationData = (RelationData)data;
            ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
            for (RelationMemberData member : relationData.getMembers()) {
                OsmPrimitive primitive = this.getDataSet().getPrimitiveById(member);
                if (primitive == null) {
                    throw new AssertionError((Object)"Data consistency problem - relation with missing member detected");
                }
                newMembers.add(new RelationMember(member.getRole(), primitive));
            }
            this.setMembers(newMembers);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public RelationData save() {
        RelationData data = new RelationData();
        this.saveCommonAttributes(data);
        for (RelationMember member : this.getMembers()) {
            data.getMembers().add(new RelationMemberData(member.getRole(), member.getMember()));
        }
        return data;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{Relation id=");
        result.append(this.getUniqueId());
        result.append(" version=");
        result.append(this.getVersion());
        result.append(" ");
        result.append(this.getFlagsAsString());
        result.append(" [");
        for (RelationMember rm : this.getMembers()) {
            result.append((Object)OsmPrimitiveType.from(rm.getMember()));
            result.append(" ");
            result.append(rm.getMember().getUniqueId());
            result.append(", ");
        }
        result.delete(result.length() - 2, result.length());
        result.append("]");
        result.append("}");
        return result.toString();
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (other == null || !(other instanceof Relation)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Relation r = (Relation)other;
        return Arrays.equals(this.members, r.members);
    }

    @Override
    public int compareTo(OsmPrimitive o) {
        return o instanceof Relation ? Long.valueOf(this.getUniqueId()).compareTo(o.getUniqueId()) : -1;
    }

    public RelationMember firstMember() {
        if (this.isIncomplete()) {
            return null;
        }
        RelationMember[] members = this.members;
        return members.length == 0 ? null : members[0];
    }

    public RelationMember lastMember() {
        if (this.isIncomplete()) {
            return null;
        }
        RelationMember[] members = this.members;
        return members.length == 0 ? null : members[members.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMembersFor(OsmPrimitive primitive) {
        if (primitive == null) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            ArrayList<RelationMember> todelete = new ArrayList<RelationMember>();
            for (RelationMember member : this.members) {
                if (member.getMember() != primitive) continue;
                todelete.add(member);
            }
            List<RelationMember> members = this.getMembers();
            members.removeAll(todelete);
            this.setMembers(members);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean deleted) {
        boolean locked = this.writeLock();
        try {
            for (RelationMember rm : this.members) {
                if (deleted) {
                    rm.getMember().removeReferrer(this);
                    continue;
                }
                rm.getMember().addReferrer(this);
            }
            super.setDeleted(deleted);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMembersFor(Collection<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        boolean locked = this.writeLock();
        try {
            ArrayList<RelationMember> todelete = new ArrayList<RelationMember>();
            for (RelationMember member : this.members) {
                if (!primitives.contains(member.getMember())) continue;
                todelete.add(member);
            }
            List<RelationMember> members = this.getMembers();
            members.removeAll(todelete);
            this.setMembers(members);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        RelationMember[] members;
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember m : members = this.members) {
            if (m.getMember() == null) continue;
            ret.add(m.getMember());
        }
        return ret;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public BBox getBBox() {
        RelationMember[] members = this.members;
        if (members.length == 0) {
            return new BBox(0.0, 0.0, 0.0, 0.0);
        }
        if (this.getDataSet() == null) {
            return this.calculateBBox(new HashSet<PrimitiveId>());
        }
        if (this.bbox == null) {
            this.bbox = this.calculateBBox(new HashSet<PrimitiveId>());
        }
        if (this.bbox == null) {
            return new BBox(0.0, 0.0, 0.0, 0.0);
        }
        return new BBox(this.bbox);
    }

    private BBox calculateBBox(Set<PrimitiveId> visitedRelations) {
        if (visitedRelations.contains(this)) {
            return null;
        }
        visitedRelations.add(this);
        RelationMember[] members = this.members;
        if (members.length == 0) {
            return null;
        }
        BBox result = null;
        for (RelationMember rm : members) {
            BBox box;
            BBox bBox = box = rm.isRelation() ? rm.getRelation().calculateBBox(visitedRelations) : rm.getMember().getBBox();
            if (box == null) continue;
            if (result == null) {
                result = box;
                continue;
            }
            result.add(box);
        }
        return result;
    }

    @Override
    public void updatePosition() {
        this.bbox = this.calculateBBox(new HashSet<PrimitiveId>());
    }

    @Override
    public void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkMembers();
        this.bbox = null;
    }

    private void checkMembers() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            RelationMember[] members;
            for (RelationMember rm : members = this.members) {
                if (rm.getMember().getDataSet() == dataSet) continue;
                throw new DataIntegrityProblemException(String.format("Relation member must be part of the same dataset as relation(%s, %s)", this.getPrimitiveId(), rm.getMember().getPrimitiveId()));
            }
            if (Main.pref.getBoolean("debug.checkDeleteReferenced", true)) {
                for (RelationMember rm : members) {
                    if (!rm.getMember().isDeleted()) continue;
                    throw new DataIntegrityProblemException("Deleted member referenced: " + this.toString());
                }
            }
        }
    }

    private void fireMembersChanged() {
        this.checkMembers();
        if (this.getDataSet() != null) {
            this.getDataSet().fireRelationMembersChanged(this);
        }
    }

    public boolean hasIncompleteMembers() {
        RelationMember[] members;
        for (RelationMember rm : members = this.members) {
            if (!rm.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public Collection<OsmPrimitive> getIncompleteMembers() {
        RelationMember[] members;
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember rm : members = this.members) {
            if (!rm.getMember().isIncomplete()) continue;
            ret.add(rm.getMember());
        }
        return ret;
    }
}

