/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.NTV2GridShift;
import org.openstreetmap.josm.data.projection.NTV2GridShiftFile;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lambert
implements Projection,
ProjectionSubPrefs {
    public static final double[] n = new double[]{0.7604059656, 0.7289686274, 0.6959127966, 0.6712679322};
    public static final double[] c = new double[]{1.160379698E7, 1.174579339E7, 1.194799252E7, 1.213628199E7};
    public static final double[] Xs = new double[]{600000.0, 600000.0, 600000.0, 234.358};
    public static final double[] Ys = new double[]{5657616.674, 6199695.768, 6791905.085, 7239161.542};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-11;
    public static final double cMaxLatZone1Radian = Math.toRadians(51.300000000000004);
    public static final double cMinLatZone1Radian = Math.toRadians(41.49);
    public static final double[][] zoneLimitsDegree = new double[][]{{Math.toDegrees(cMaxLatZone1Radian), 48.15}, {48.15, 45.45}, {45.45, 42.300000000000004}, {42.767667, Math.toDegrees(cMinLatZone1Radian)}};
    public static final double cMinLonZonesRadian = Math.toRadians(-4.416666666666665);
    public static final double cMaxLonZonesRadian = Math.toRadians(9.18);
    public static final double cMaxOverlappingZonesDegree = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private int layoutZone = 0;
    private static NTV2GridShiftFile ntf_rgf93Grid = null;
    public static String[] lambert4zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, "51.30", "48.15"), I18n.tr("{0} ({1} to {2} degrees)", 2, "48.15", "45.45"), I18n.tr("{0} ({1} to {2} degrees)", 3, "45.45", "42.76"), I18n.tr("{0} (Corsica)", 4)};

    public static NTV2GridShiftFile getNtf_rgf93Grid() {
        return ntf_rgf93Grid;
    }

    public Lambert() {
        if (ntf_rgf93Grid == null) {
            try {
                String gridFileName = "ntf_r93_b.gsb";
                InputStream is = Main.class.getResourceAsStream("/data/" + gridFileName);
                if (is == null) {
                    System.err.println(I18n.tr("Warning: failed to open input stream for resource ''/data/{0}''. Cannot load NTF<->RGF93 grid", gridFileName));
                    return;
                }
                ntf_rgf93Grid = new NTV2GridShiftFile();
                ntf_rgf93Grid.loadGridShiftFile(is, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon p) {
        LatLon geo = this.WGS84_to_NTF(p);
        double lt = Math.toRadians(geo.lat());
        double lg = Math.toRadians(geo.lon());
        if (lt >= cMinLatZone1Radian && lt <= cMaxLatZone1Radian && lg >= cMinLonZonesRadian && lg <= cMaxLonZonesRadian) {
            return this.ConicProjection(lt, lg, Xs[this.layoutZone], Ys[this.layoutZone], c[this.layoutZone], n[this.layoutZone]);
        }
        return this.ConicProjection(lt, lg, Xs[0], Ys[0], c[0], n[0]);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth p) {
        LatLon geo = this.Geographic(p, Xs[this.layoutZone], Ys[this.layoutZone], c[this.layoutZone], n[this.layoutZone]);
        return this.NTF_to_WGS84(geo);
    }

    @Override
    public String toString() {
        return I18n.tr("Lambert 4 Zones (France)");
    }

    @Override
    public String toCode() {
        return "EPSG:" + (27561 + this.layoutZone);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.layoutZone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "lambert";
    }

    private EastNorth ConicProjection(double lat, double lon, double Xs, double Ys, double c, double n) {
        double eslt = Ellipsoid.clarke.e * Math.sin(lat);
        double l = Math.log(Math.tan(0.7853981633974483 + lat / 2.0) * Math.pow((1.0 - eslt) / (1.0 + eslt), Ellipsoid.clarke.e / 2.0));
        double east = Xs + c * Math.exp(-n * l) * Math.sin(n * (lon - 0.04079234433198));
        double north = Ys - c * Math.exp(-n * l) * Math.cos(n * (lon - 0.04079234433198));
        return new EastNorth(east, north);
    }

    private LatLon Geographic(EastNorth eastNorth, double Xs, double Ys, double c, double n) {
        double dx = eastNorth.east() - Xs;
        double dy = Ys - eastNorth.north();
        double R = Math.sqrt(dx * dx + dy * dy);
        double gamma = Math.atan(dx / dy);
        double l = -1.0 / n * Math.log(Math.abs(R / c));
        l = Math.exp(l);
        double lon = 0.04079234433198 + gamma / n;
        double lat = 2.0 * Math.atan(l) - 1.5707963267948966;
        double delta = 1.0;
        while (delta > 1.0E-11) {
            double eslt = Ellipsoid.clarke.e * Math.sin(lat);
            double nlt = 2.0 * Math.atan(Math.pow((1.0 + eslt) / (1.0 - eslt), Ellipsoid.clarke.e / 2.0) * l) - 1.5707963267948966;
            delta = Math.abs(nlt - lat);
            lat = nlt;
        }
        return new LatLon(Math.toDegrees(lat), Math.toDegrees(lon));
    }

    private LatLon WGS84_to_NTF(LatLon wgs) {
        NTV2GridShift gs = new NTV2GridShift(wgs);
        if (ntf_rgf93Grid != null) {
            ntf_rgf93Grid.gridShiftReverse(gs);
            return new LatLon(wgs.lat() + gs.getLatShiftDegrees(), wgs.lon() + gs.getLonShiftPositiveEastDegrees());
        }
        return new LatLon(0.0, 0.0);
    }

    private LatLon NTF_to_WGS84(LatLon ntf) {
        NTV2GridShift gs = new NTV2GridShift(ntf);
        if (ntf_rgf93Grid != null) {
            ntf_rgf93Grid.gridShiftForward(gs);
            return new LatLon(ntf.lat() + gs.getLatShiftDegrees(), ntf.lon() + gs.getLonShiftPositiveEastDegrees());
        }
        return new LatLon(0.0, 0.0);
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        Bounds b = new Bounds(new LatLon(Math.max(zoneLimitsDegree[this.layoutZone][1] - 1.5, Math.toDegrees(cMinLatZone1Radian)), Math.toDegrees(cMinLonZonesRadian)), new LatLon(Math.min(zoneLimitsDegree[this.layoutZone][0] + 1.5, Math.toDegrees(cMaxLatZone1Radian)), Math.toDegrees(cMaxLonZonesRadian)));
        return b;
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    public int getLayoutZone() {
        return this.layoutZone;
    }

    @Override
    public void setupPreferencePanel(JPanel p) {
        JComboBox<String> prefcb = new JComboBox<String>(lambert4zones);
        prefcb.setSelectedIndex(this.layoutZone);
        p.setLayout(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Lambert CC Zone")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add(prefcb, GBC.eop().fill(2));
        p.add((Component)new JLabel(ImageProvider.get("data/projection", "Departements_Lambert4Zones.png")), GBC.eol().fill(2));
        p.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel p) {
        Component prefcb = p.getComponent(2);
        if (!(prefcb instanceof JComboBox)) {
            return null;
        }
        this.layoutZone = ((JComboBox)prefcb).getSelectedIndex();
        return Collections.singleton(Integer.toString(this.layoutZone + 1));
    }

    @Override
    public void setPreferences(Collection<String> args) {
        this.layoutZone = 0;
        if (args != null) {
            try {
                Iterator<String> i$ = args.iterator();
                if (i$.hasNext()) {
                    String s = i$.next();
                    this.layoutZone = Integer.parseInt(s) - 1;
                    if (this.layoutZone < 0 || this.layoutZone > 3) {
                        this.layoutZone = 0;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if (code.startsWith("EPSG:2756") && code.length() == 9) {
            try {
                String zonestring = code.substring(9);
                int zoneval = Integer.parseInt(zonestring);
                if (zoneval >= 1 && zoneval <= 4) {
                    return Collections.singleton(zonestring);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

