/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.WayNodesConflictResolverCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListMergeModel
extends ListMergeModel<Node> {
    private DataSet myDataset;

    public void populate(Way my, Way their) {
        this.myDataset = my.getDataSet();
        CheckParameterUtil.ensureParameterNotNull(my, "my");
        CheckParameterUtil.ensureParameterNotNull(their, "their");
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (Node n : my.getNodes()) {
            this.getMyEntries().add(n);
        }
        for (Node n : their.getNodes()) {
            this.getTheirEntries().add(n);
        }
        if (this.myAndTheirEntriesEqual()) {
            this.entries.put(ListRole.MERGED_ENTRIES, new ArrayList(this.getMyEntries()));
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    public WayNodesConflictResolverCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command."));
        }
        return new WayNodesConflictResolverCommand(conflict, this.getMergedEntries());
    }

    @Override
    public boolean isEqualEntry(Node e1, Node e2) {
        if (!e1.isNew()) {
            return e1.getId() == e2.getId();
        }
        return e1 == e2;
    }

    @Override
    protected void setValueAt(DefaultTableModel model, Object value, int row, int col) {
    }

    @Override
    protected Node cloneEntryForMergedList(Node entry) {
        return (Node)this.getMyPrimitive(entry);
    }

    @Override
    protected OsmPrimitive getMyPrimitive(Node entry) {
        return this.myDataset.getPrimitiveById(entry);
    }
}

