/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_FROZEN = new Color(234, 234, 234);
    public static final Color BGCOLOR_PARTICIPAING_IN_COMPARISON = Color.BLACK;
    public static final Color FGCOLOR_PARTICIPAING_IN_COMPARISON = Color.WHITE;
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SAME_POSITION_IN_OPPOSITE = new Color(217, 255, 217);
    private final ImageIcon icon = ImageProvider.get("data", "node");
    private final Border rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
    }

    public String buildToolTipText(OsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(primitive.getId()).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(primitive.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = primitive.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    protected void reset() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
    }

    protected void renderNode(ListMergeModel.EntriesTableModel model, Node node, int row, boolean isSelected) {
        this.setIcon(this.icon);
        this.setBorder(null);
        if (model.getListMergeModel().isFrozen()) {
            this.setBackground(BGCOLOR_FROZEN);
        } else if (isSelected) {
            this.setBackground(BGCOLOR_SELECTED);
        } else if (model.isParticipatingInCurrentComparePair()) {
            if (model.isSamePositionInOppositeList(row)) {
                this.setBackground(BGCOLOR_SAME_POSITION_IN_OPPOSITE);
            } else if (model.isIncludedInOppositeList(row)) {
                this.setBackground(BGCOLOR_IN_OPPOSITE);
            } else {
                this.setBackground(BGCOLOR_NOT_IN_OPPOSITE);
            }
        }
        this.setText(node.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(this.buildToolTipText(node));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(BGCOLOR_EMPTY_ROW);
        this.setText("");
    }

    protected void renderRowId(ListMergeModel.EntriesTableModel model, int row, boolean isSelected) {
        this.setIcon(null);
        this.setBorder(this.rowNumberBorder);
        if (model.getListMergeModel().isFrozen()) {
            this.setBackground(BGCOLOR_FROZEN);
        } else if (model.isParticipatingInCurrentComparePair()) {
            this.setBackground(BGCOLOR_PARTICIPAING_IN_COMPARISON);
            this.setForeground(FGCOLOR_PARTICIPAING_IN_COMPARISON);
        }
        this.setText(Integer.toString(row + 1));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Node node = (Node)value;
        this.reset();
        switch (column) {
            case 0: {
                this.renderRowId(this.getModel(table), row, isSelected);
                break;
            }
            case 1: {
                if (node == null) {
                    this.renderEmptyRow();
                    break;
                }
                this.renderNode(this.getModel(table), node, row, isSelected);
                break;
            }
            default: {
                throw new RuntimeException(MessageFormat.format("Unexpected column index. Got {0}.", column));
            }
        }
        return this;
    }

    protected ListMergeModel.EntriesTableModel getModel(JTable table) {
        return (ListMergeModel.EntriesTableModel)table.getModel();
    }
}

