/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberConflictDecision {
    private Relation relation;
    private int pos;
    private OsmPrimitive originalPrimitive;
    private String role;
    private RelationMemberConflictDecisionType decision;

    public RelationMemberConflictDecision(Relation relation, int pos) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(relation, "relation");
        RelationMember member = relation.getMember(pos);
        if (member == null) {
            throw new IndexOutOfBoundsException(I18n.tr("Position {0} is out of range. Current number of members is {1}.", pos, relation.getMembersCount()));
        }
        this.relation = relation;
        this.pos = pos;
        this.originalPrimitive = member.getMember();
        this.role = member.hasRole() ? member.getRole() : "";
        this.decision = RelationMemberConflictDecisionType.UNDECIDED;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public int getPos() {
        return this.pos;
    }

    public OsmPrimitive getOriginalPrimitive() {
        return this.originalPrimitive;
    }

    public String getRole() {
        return this.role;
    }

    public RelationMemberConflictDecisionType getDecision() {
        return this.decision;
    }

    public void setRole(String role) {
        this.role = role == null ? "" : role;
    }

    public void decide(RelationMemberConflictDecisionType decision) {
        if (decision == null) {
            decision = RelationMemberConflictDecisionType.UNDECIDED;
        }
        this.decision = decision;
    }

    public boolean isDecided() {
        return !RelationMemberConflictDecisionType.UNDECIDED.equals((Object)this.decision);
    }

    public boolean matches(Relation relation, int pos) {
        return this.relation == relation && this.pos == pos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.decision == null ? 0 : this.decision.hashCode());
        result = 31 * result + (this.originalPrimitive == null ? 0 : this.originalPrimitive.hashCode());
        result = 31 * result + this.pos;
        result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationMemberConflictDecision other = (RelationMemberConflictDecision)obj;
        if (this.decision == null ? other.decision != null : !this.decision.equals((Object)other.decision)) {
            return false;
        }
        if (this.originalPrimitive == null ? other.originalPrimitive != null : !this.originalPrimitive.equals(other.originalPrimitive)) {
            return false;
        }
        if (this.pos != other.pos) {
            return false;
        }
        if (this.relation == null ? other.relation != null : !this.relation.equals(other.relation)) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }
}

