/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RelationListDialog
extends ToggleDialog
implements DataSetListener {
    private JList displaylist;
    private RelationListModel model;
    private EditAction editAction;
    private DeleteAction deleteAction;
    private NewAction newAction;
    private RelationDialogPopupMenu popupMenu;

    public RelationListDialog() {
        super(I18n.tr("Relations"), "relationlist", I18n.tr("Open a list of all relations."), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations")), 82, 4, 1), 150);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new RelationListModel(selectionModel);
        this.displaylist = new JList(this.model);
        this.displaylist.setSelectionModel(selectionModel);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer(){

            protected String getComponentToolTipText(OsmPrimitive value) {
                return null;
            }
        });
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseEventHandler());
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel tp = this.getButtonPanel(5);
        this.newAction = new NewAction();
        tp.add(new SideButton((Action)this.newAction, false));
        this.editAction = new EditAction();
        this.displaylist.addListSelectionListener(this.editAction);
        tp.add(new SideButton((Action)this.editAction, false));
        DuplicateAction duplicateAction = new DuplicateAction();
        this.displaylist.addListSelectionListener(duplicateAction);
        tp.add(new SideButton((Action)duplicateAction, false));
        this.deleteAction = new DeleteAction();
        this.displaylist.addListSelectionListener(this.deleteAction);
        tp.add(new SideButton((Action)this.deleteAction, false));
        SelectAction selectAction = new SelectAction();
        this.displaylist.addListSelectionListener(selectAction);
        tp.add(new SideButton((Action)selectAction, false));
        this.add((Component)tp, "South");
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteRelation");
        this.displaylist.getActionMap().put("deleteRelation", this.deleteAction);
        this.popupMenu = new RelationDialogPopupMenu();
    }

    public void showNotify() {
        MapView.addLayerChangeListener(this.newAction);
        this.newAction.updateEnabledState();
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
        this.dataChanged(null);
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener(this.newAction);
        DatasetEventManager.getInstance().removeDatasetListener(this);
    }

    protected void initFromLayer(Layer layer) {
        if (layer == null || !(layer instanceof OsmDataLayer)) {
            this.model.setRelations(null);
            return;
        }
        OsmDataLayer l = (OsmDataLayer)layer;
        this.model.setRelations(l.data.getRelations());
        this.model.updateTitle();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.displaylist.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.displaylist.removeListSelectionListener(listener);
    }

    private Relation getSelected() {
        if (this.model.getSize() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        if (relation == null) {
            this.model.setSelectedRelations(null);
        } else {
            this.model.setSelectedRelations(Collections.singletonList(relation));
            Integer i = this.model.getRelationIndex(relation);
            if (i != null) {
                this.displaylist.scrollRectToVisible(this.displaylist.getCellBounds(i, i));
            }
        }
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
        this.model.addRelations(event.getPrimitives());
        this.model.updateTitle();
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        this.model.removeRelations(event.getPrimitives());
        this.model.updateTitle();
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
        List<Relation> sel = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(sel);
        this.displaylist.repaint();
    }

    public void tagsChanged(TagsChangedEvent event) {
        OsmPrimitive prim = event.getPrimitive();
        if (prim == null || !(prim instanceof Relation)) {
            return;
        }
        List<Relation> sel = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(sel);
        this.displaylist.repaint();
    }

    public void dataChanged(DataChangedEvent event) {
        this.initFromLayer(Main.main.getEditLayer());
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    class RelationDialogPopupMenu
    extends JPopupMenu {
        protected void build() {
            DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
            RelationListDialog.this.displaylist.addListSelectionListener(downloadMembersAction);
            this.add(downloadMembersAction);
            DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembers = new DownloadSelectedIncompleteMembersAction();
            RelationListDialog.this.displaylist.addListSelectionListener(downloadSelectedIncompleteMembers);
            this.add(downloadSelectedIncompleteMembers);
            this.addSeparator();
            SelectMembersAction selectMembersAction = new SelectMembersAction();
            RelationListDialog.this.displaylist.addListSelectionListener(selectMembersAction);
            this.add(selectMembersAction);
        }

        public RelationDialogPopupMenu() {
            this.build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationListModel
    extends AbstractListModel {
        private final ArrayList<Relation> relations = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public RelationListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public Relation getRelation(int idx) {
            return this.relations.get(idx);
        }

        public void sort() {
            Collections.sort(this.relations, new Comparator<Relation>(){
                NameFormatter formatter = DefaultNameFormatter.getInstance();

                @Override
                public int compare(Relation r1, Relation r2) {
                    return r1.getDisplayName(this.formatter).compareTo(r2.getDisplayName(this.formatter));
                }
            });
        }

        private boolean isValid(Relation r) {
            return !r.isDeleted() && r.isVisible() && !r.isIncomplete();
        }

        public void setRelations(Collection<Relation> relations) {
            List<Relation> sel = this.getSelectedRelations();
            this.relations.clear();
            if (relations == null) {
                this.selectionModel.clearSelection();
                this.fireContentsChanged(this, 0, this.getSize());
                return;
            }
            for (Relation r : relations) {
                if (!this.isValid(r)) continue;
                this.relations.add(r);
            }
            this.sort();
            this.fireIntervalAdded(this, 0, this.getSize());
            this.setSelectedRelations(sel);
        }

        public void addRelations(Collection<? extends OsmPrimitive> addedPrimitives) {
            boolean added = false;
            for (OsmPrimitive osmPrimitive : addedPrimitives) {
                Relation r;
                if (!(osmPrimitive instanceof Relation) || this.relations.contains(r = (Relation)osmPrimitive) || !this.isValid(r)) continue;
                this.relations.add(r);
                added = true;
            }
            if (added) {
                List<Relation> sel = this.getSelectedRelations();
                this.sort();
                this.fireIntervalAdded(this, 0, this.getSize());
                this.setSelectedRelations(sel);
            }
        }

        public void removeRelations(Collection<? extends OsmPrimitive> removedPrimitives) {
            if (removedPrimitives == null) {
                return;
            }
            HashSet<Relation> removedRelations = new HashSet<Relation>();
            for (OsmPrimitive osmPrimitive : removedPrimitives) {
                if (!(osmPrimitive instanceof Relation)) continue;
                removedRelations.add((Relation)osmPrimitive);
            }
            if (removedRelations.isEmpty()) {
                return;
            }
            int size = this.relations.size();
            this.relations.removeAll(removedRelations);
            if (size != this.relations.size()) {
                List<Relation> list = this.getSelectedRelations();
                this.sort();
                this.fireContentsChanged(this, 0, this.getSize());
                this.setSelectedRelations(list);
            }
        }

        public List<Relation> getSelectedRelationsWithIncompleteMembers() {
            List<Relation> ret = this.getSelectedNonNewRelations();
            Iterator<Relation> it = ret.iterator();
            while (it.hasNext()) {
                Relation r = it.next();
                if (r.hasIncompleteMembers()) continue;
                it.remove();
            }
            return ret;
        }

        @Override
        public Object getElementAt(int index) {
            return this.relations.get(index);
        }

        @Override
        public int getSize() {
            return this.relations.size();
        }

        public List<Relation> getSelectedNonNewRelations() {
            ArrayList<Relation> ret = new ArrayList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i) || this.relations.get(i).isNew()) continue;
                ret.add(this.relations.get(i));
            }
            return ret;
        }

        public List<Relation> getSelectedRelations() {
            ArrayList<Relation> ret = new ArrayList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ret.add(this.relations.get(i));
            }
            return ret;
        }

        public void setSelectedRelations(List<Relation> sel) {
            this.selectionModel.clearSelection();
            if (sel == null || sel.isEmpty()) {
                return;
            }
            for (Relation r : sel) {
                int i = this.relations.indexOf(r);
                if (i < 0) continue;
                this.selectionModel.addSelectionInterval(i, i);
            }
        }

        public Integer getRelationIndex(Relation rel) {
            int i = this.relations.indexOf(rel);
            if (i < 0) {
                return null;
            }
            return i;
        }

        public void updateTitle() {
            if (this.getSize() > 0) {
                RelationListDialog.this.setTitle(I18n.tr("Relations: {0}", this.getSize()));
            } else {
                RelationListDialog.this.setTitle(I18n.tr("Relations"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadSelectedIncompleteMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download incomplete members"));
            this.updateEnabledState();
        }

        public Set<OsmPrimitive> buildSetOfIncompleteMembers(List<Relation> rels) {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (Relation r : rels) {
                ret.addAll(r.getIncompleteMembers());
            }
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> rels = RelationListDialog.this.model.getSelectedRelationsWithIncompleteMembers();
            if (rels.isEmpty()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(rels, this.buildSetOfIncompleteMembers(rels), Main.map.mapView.getEditLayer()));
        }

        protected void updateEnabledState() {
            this.setEnabled(!RelationListDialog.this.model.getSelectedRelationsWithIncompleteMembers().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class DownloadMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download all members of the selected relations"));
            this.putValue("Name", I18n.tr("Download members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "downloadincomplete"));
            this.putValue("help", HelpUtil.ht("/Dialog/RelationList#DownloadMembers"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(!RelationListDialog.this.model.getSelectedNonNewRelations().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            List<Relation> relations = RelationListDialog.this.model.getSelectedNonNewRelations();
            if (relations.isEmpty()) {
                return;
            }
            Main.worker.submit(new DownloadRelationTask(RelationListDialog.this.model.getSelectedNonNewRelations(), Main.map.mapView.getEditLayer()));
        }
    }

    class SelectMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Select the members of all selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("selectall"));
            this.putValue("Name", I18n.tr("Select members"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> relations = RelationListDialog.this.model.getSelectedRelations();
            HashSet<OsmPrimitive> members = new HashSet<OsmPrimitive>();
            for (Relation r : relations) {
                members.addAll(r.getMemberPrimitives());
            }
            Main.map.mapView.getEditLayer().data.setSelected(members);
        }

        protected void updateEnabledState() {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("ShortDescription", I18n.tr("Set the current selection to the list of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            int[] idx = RelationListDialog.this.displaylist.getSelectedIndices();
            if (idx == null || idx.length == 0) {
                return;
            }
            ArrayList<Relation> selection = new ArrayList<Relation>(idx.length);
            for (int i : idx) {
                selection.add(RelationListDialog.this.model.getRelation(i));
            }
            Main.map.mapView.getEditLayer().data.setSelected(selection);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }
    }

    class DuplicateAction
    extends AbstractAction
    implements ListSelectionListener {
        public DuplicateAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window"));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.updateEnabledState();
        }

        public void launchEditorForDuplicate(Relation original) {
            Relation copy = new Relation(original, true);
            copy.setModified(true);
            RelationEditor editor = RelationEditor.getEditor(Main.main.getEditLayer(), copy, null);
            editor.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditorForDuplicate(RelationListDialog.this.getSelected());
        }

        protected void updateEnabledState() {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class NewAction
    extends AbstractAction
    implements MapView.LayerChangeListener {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "addrelation"));
            this.updateEnabledState();
        }

        public void run() {
            RelationEditor.getEditor(Main.main.getEditLayer(), null, null).setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.setEnabled(false);
        }

        protected void deleteRelation(Relation toDelete) {
            if (toDelete == null) {
                return;
            }
            org.openstreetmap.josm.actions.mapmode.DeleteAction.deleteRelation(Main.main.getEditLayer(), toDelete);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            int[] idx = RelationListDialog.this.displaylist.getSelectedIndices();
            ArrayList<Relation> toDelete = new ArrayList<Relation>(idx.length);
            for (int i : idx) {
                toDelete.add(RelationListDialog.this.model.getRelation(i));
            }
            for (Relation r : toDelete) {
                this.deleteRelation(r);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Open an editor for the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.setEnabled(false);
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation r) {
            HashSet<RelationMember> members = new HashSet<RelationMember>();
            Collection<OsmPrimitive> selection = Main.map.mapView.getEditLayer().data.getSelected();
            for (RelationMember member : r.getMembers()) {
                if (!selection.contains(member.getMember())) continue;
                members.add(member);
            }
            return members;
        }

        public void launchEditor(Relation toEdit) {
            if (toEdit == null) {
                return;
            }
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), toEdit, this.getMembersForCurrentSelection(toEdit)).setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditor(RelationListDialog.this.getSelected());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }
    }

    class MouseEventHandler
    extends MouseAdapter {
        MouseEventHandler() {
        }

        protected void setCurrentRelationAsSelection() {
            Main.main.getCurrentDataSet().setSelected((Relation)RelationListDialog.this.displaylist.getSelectedValue());
        }

        protected void editCurrentRelation() {
            new EditAction().launchEditor(RelationListDialog.this.getSelected());
        }

        public void mouseClicked(MouseEvent e) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                if (e.isControlDown()) {
                    this.editCurrentRelation();
                } else {
                    this.setCurrentRelationAsSelection();
                }
            }
        }

        private void openPopup(MouseEvent e) {
            Point p = e.getPoint();
            int index = RelationListDialog.this.displaylist.locationToIndex(p);
            if (index < 0) {
                return;
            }
            if (!RelationListDialog.this.displaylist.getCellBounds(index, index).contains(e.getPoint())) {
                return;
            }
            if (!RelationListDialog.this.displaylist.isSelectedIndex(index)) {
                RelationListDialog.this.displaylist.setSelectedIndex(index);
            }
            RelationListDialog.this.popupMenu.show(RelationListDialog.this.displaylist, p.x, p.y - 3);
        }

        public void mousePressed(MouseEvent e) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.openPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (Main.main.getEditLayer() == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.openPopup(e);
            }
        }
    }
}

