/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;

public class OpenChangesetComboBoxModel
extends DefaultComboBoxModel
implements ChangesetCacheListener {
    private List<Changeset> changesets = new ArrayList<Changeset>();
    private Changeset selectedChangeset = null;

    protected Changeset getChangesetById(long id) {
        for (Changeset cs : this.changesets) {
            if ((long)cs.getId() != id) continue;
            return cs;
        }
        return null;
    }

    public void refresh() {
        this.changesets.clear();
        this.changesets.addAll(ChangesetCache.getInstance().getOpenChangesets());
        this.fireContentsChanged(this, 0, this.getSize());
        int idx = this.changesets.indexOf(this.selectedChangeset);
        if (idx < 0) {
            this.selectFirstChangeset();
        } else {
            this.setSelectedItem(this.changesets.get(idx));
        }
    }

    public void selectFirstChangeset() {
        if (this.changesets == null || this.changesets.isEmpty()) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(this.changesets.get(0));
        }
    }

    public void changesetCacheUpdated(ChangesetCacheEvent event) {
        this.refresh();
    }

    public Object getElementAt(int index) {
        return this.changesets.get(index);
    }

    public int getIndexOf(Object anObject) {
        return this.changesets.indexOf(anObject);
    }

    public int getSize() {
        return this.changesets.size();
    }

    public Object getSelectedItem() {
        return this.selectedChangeset;
    }

    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            this.selectedChangeset = null;
            super.setSelectedItem(null);
            return;
        }
        if (!(anObject instanceof Changeset)) {
            return;
        }
        Changeset cs = (Changeset)anObject;
        if (cs.getId() == 0 || !cs.isOpen()) {
            return;
        }
        Changeset candidate = this.getChangesetById(cs.getId());
        if (candidate == null) {
            return;
        }
        this.selectedChangeset = candidate;
        super.setSelectedItem(this.selectedChangeset);
    }
}

