/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;

class SaveFlagCellEditor
extends JCheckBox
implements TableCellEditor {
    private CopyOnWriteArrayList<CellEditorListener> listeners = new CopyOnWriteArrayList();
    private boolean value;

    public SaveFlagCellEditor() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                SaveFlagCellEditor.this.stopCellEditing();
            }
        });
    }

    public void addCellEditorListener(CellEditorListener l) {
        if (l != null) {
            this.listeners.addIfAbsent(l);
        }
    }

    protected void fireEditingCanceled() {
        for (CellEditorListener l : this.listeners) {
            l.editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        for (CellEditorListener l : this.listeners) {
            l.editingStopped(new ChangeEvent(this));
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public void setInitialValue(boolean value) {
        this.value = value;
        this.setSelected(value);
    }

    public boolean stopCellEditing() {
        this.value = this.isSelected();
        this.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        SaveLayerInfo info = (SaveLayerInfo)value;
        switch (column) {
            case 4: {
                this.setInitialValue(info.isDoUploadToServer());
                break;
            }
            case 5: {
                this.setInitialValue(info.isDoSaveToFile());
            }
        }
        return this;
    }
}

