/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.ConfigurationParameterRequestHandler;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadParameterSummaryPanel
extends JPanel
implements HyperlinkListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(UploadParameterSummaryPanel.class.getName());
    private UploadStrategySpecification spec = new UploadStrategySpecification();
    private int numObjects;
    private JEditorPane jepMessage;
    private JLabel lblWarning;
    private Changeset selectedChangeset;
    private boolean closeChangesetAfterNextUpload;
    private ConfigurationParameterRequestHandler configHandler;

    protected String buildChangesetSummary() {
        StringBuffer msg = new StringBuffer();
        if (this.selectedChangeset == null || this.selectedChangeset.isNew()) {
            msg.append(I18n.tr("Objects are uploaded to a <strong>new changeset</strong>."));
        } else {
            String uploadComment = this.selectedChangeset.get("comment") == null ? "" : this.selectedChangeset.get("comment");
            msg.append(I18n.tr("Objects are uploaded to the <strong>open changeset</strong> {0} with upload comment ''{1}''.", this.selectedChangeset.getId(), uploadComment));
        }
        msg.append(" ");
        if (this.closeChangesetAfterNextUpload) {
            msg.append(I18n.tr("The changeset is going to be <strong>closed</strong> after this upload"));
        } else {
            msg.append(I18n.tr("The changeset is <strong>left open</strong> after this upload"));
        }
        msg.append(" (<a href=\"urn:changeset-configuration\">" + I18n.tr("configure changeset") + "</a>)");
        return msg.toString();
    }

    protected String buildStrategySummary() {
        if (this.spec == null) {
            return "";
        }
        boolean useOneChangeset = true;
        int maxChunkSize = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        if (maxChunkSize > 0 && this.numObjects > maxChunkSize) {
            useOneChangeset = false;
        }
        int numRequests = this.spec.getNumRequests(this.numObjects);
        String msg = null;
        if (useOneChangeset) {
            this.lblWarning.setVisible(false);
            if (numRequests == 0) {
                msg = I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong>", this.numObjects, this.numObjects);
            } else if (numRequests == 1) {
                msg = I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", this.numObjects, this.numObjects);
            } else if (numRequests > 1) {
                msg = I18n.tr("Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>{1} requests</strong>", this.numObjects, numRequests);
            }
            msg = msg + " (<a href=\"urn:advanced-configuration\">" + I18n.tr("advanced configuration") + "</a>)";
        } else {
            this.lblWarning.setVisible(true);
            if (numRequests == 0) {
                msg = I18n.tr("{0} objects exceed the max. allowed {1} objects in a changeset on the server ''{2}''. Please <a href=\"urn:advanced-configuration\">configure</a> how to proceed with <strong>multiple changesets</strong>", this.numObjects, maxChunkSize, OsmApi.getOsmApi().getBaseUrl());
            } else if (numRequests > 1) {
                msg = I18n.tr("Uploading <strong>{0} objects</strong> to <strong>multiple changesets</strong> using <strong>{1} requests</strong>", this.numObjects, numRequests);
                msg = msg + " (<a href=\"urn:advanced-configuration\">" + I18n.tr("advanced configuration") + "</a>)";
            }
        }
        return msg;
    }

    protected void build() {
        this.jepMessage = new JEditorPane("text/html", "");
        this.jepMessage.setOpaque(false);
        this.jepMessage.setEditable(false);
        this.jepMessage.addHyperlinkListener(this);
        Font f = UIManager.getFont("Label.font");
        StyleSheet ss = new StyleSheet();
        String rule = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), f.isBold() ? "bold" : "normal", f.isItalic() ? "italic" : "normal");
        rule = "body {" + rule + "}";
        rule = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), "bold", f.isItalic() ? "italic" : "normal");
        rule = "strong {" + rule + "}";
        ss.addRule(rule);
        ss.addRule("a {text-decoration: underline; color: blue}");
        HTMLEditorKit kit = new HTMLEditorKit();
        kit.setStyleSheet(ss);
        this.jepMessage.setEditorKit(kit);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jepMessage, "Center");
        this.lblWarning = new JLabel("");
        this.lblWarning.setVisible(false);
        this.lblWarning.setIcon(ImageProvider.get("warning-small.png"));
        this.lblWarning.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.lblWarning, "North");
        this.add((Component)pnl, "West");
    }

    public UploadParameterSummaryPanel() {
        this.build();
        this.updateSummary();
    }

    public void setConfigurationParameterRequestListener(ConfigurationParameterRequestHandler handler) {
        this.configHandler = handler;
    }

    public void setUploadStrategySpecification(UploadStrategySpecification spec) {
        this.spec = spec;
        this.updateSummary();
    }

    public void setNumObjects(int numObjects) {
        this.numObjects = numObjects;
        this.updateSummary();
    }

    public void setCloseChangesetAfterNextUpload(boolean value) {
        this.closeChangesetAfterNextUpload = value;
        this.updateSummary();
    }

    protected void updateSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(this.buildStrategySummary());
        sb.append("<br><br>");
        sb.append(this.buildChangesetSummary());
        sb.append("</html>");
        this.jepMessage.setText(sb.toString());
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            if (e.getDescription() == null || this.configHandler == null) {
                return;
            }
            if (e.getDescription().equals("urn:changeset-configuration")) {
                this.configHandler.handleChangesetConfigurationRequest();
            } else if (e.getDescription().equals("urn:advanced-configuration")) {
                this.configHandler.handleUploadStrategyConfigurationRequest();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            this.selectedChangeset = (Changeset)evt.getNewValue();
            this.updateSummary();
        } else if (evt.getPropertyName().equals(ChangesetManagementPanel.CLOSE_CHANGESET_AFTER_UPLOAD)) {
            this.closeChangesetAfterNextUpload = (Boolean)evt.getNewValue();
            this.updateSummary();
        } else if (evt.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.numObjects = (Integer)evt.getNewValue();
            this.updateSummary();
        } else if (evt.getPropertyName().equals(UploadStrategySelectionPanel.UPLOAD_STRATEGY_SPECIFICATION_PROP)) {
            this.spec = (UploadStrategySpecification)evt.getNewValue();
            this.updateSummary();
        }
    }
}

