/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.AudioPlayer;

public class AudioMarker
extends ButtonMarker {
    private URL audioUrl;
    private static AudioMarker recentlyPlayedMarker = null;
    public double syncOffset;
    public boolean timeFromAudio = false;

    public static AudioMarker create(LatLon ll, String text, String url, MarkerLayer parentLayer, double time, double offset) {
        try {
            return new AudioMarker(ll, text, new URL(url), parentLayer, time, offset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private AudioMarker(LatLon ll, String text, URL audioUrl, MarkerLayer parentLayer, double time, double offset) {
        super(ll, text, "speech.png", parentLayer, time, offset);
        this.audioUrl = audioUrl;
        this.syncOffset = 0.0;
        this.timeFromAudio = false;
    }

    public void actionPerformed(ActionEvent ev) {
        this.play();
    }

    public static AudioMarker recentlyPlayedMarker() {
        return recentlyPlayedMarker;
    }

    public URL url() {
        return this.audioUrl;
    }

    public void play(double after) {
        try {
            Main.map.mapView.playHeadMarker.animate();
            AudioPlayer.play(this.audioUrl, this.offset + this.syncOffset + after);
            recentlyPlayedMarker = this;
        }
        catch (Exception e) {
            AudioPlayer.audioMalfunction(e);
        }
    }

    public void play() {
        this.play(0.0);
    }

    public void adjustOffset(double adjustment) {
        this.syncOffset = adjustment;
    }

    public double syncOffset() {
        return this.syncOffset;
    }

    public static String inventName(double offset) {
        int wholeSeconds = (int)(offset + 0.5);
        if (wholeSeconds < 60) {
            return Integer.toString(wholeSeconds);
        }
        if (wholeSeconds < 3600) {
            return String.format("%d:%02d", wholeSeconds / 60, wholeSeconds % 60);
        }
        return String.format("%d:%02d:%02d", wholeSeconds / 3600, wholeSeconds % 3600 / 60, wholeSeconds % 60);
    }
}

