/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ApiUrlTestTask
extends PleaseWaitRunnable {
    private String url;
    private boolean canceled;
    private boolean success;
    private Component parent;
    private HttpURLConnection connection;

    public ApiUrlTestTask(Component parent, String url) throws IllegalArgumentException {
        super(parent, I18n.tr("Testing OSM API URL ''{0}''", url), false);
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        this.parent = parent;
        this.url = url;
    }

    protected void alertInvalidUrl(String url) {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>''{0}'' is not a valid OSM API URL.<br>Please check the spelling and validate again.</html>", url), I18n.tr("Invalid API URL"), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIUrl"));
    }

    protected void alertInvalidChangesetUrl(String url) {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Failed to build URL ''{0}'' for validating the OSM API server.<br>Please check the spelling of ''{1}'' and validate again.</html>", url, this.getNormalizedApiUrl()), I18n.tr("Invalid API URL"), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIGetChangesetsUrl"));
    }

    protected void alertConnectionFailed() {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Failed to connect to the URL ''{0}''.<br>Please check the spelling of ''{1}'' and your Internet connection and validate again.</html>", this.url, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed"), 0, HelpUtil.ht("/Preferences/Connection#ConnectionToAPIFailed"));
    }

    protected void alertInvalidServerResult(int retCode) {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Failed to retrieve a list of changesets from the OSM API server at<br>''{1}''. The server responded with the return code {0} instead of 200.<br>Please check the spelling of ''{1}'' and validate again.</html>", retCode, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed"), 0, HelpUtil.ht("/Preferences/Connection#InvalidServerResult"));
    }

    protected void alertInvalidChangesetList() {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>The OSM API server at ''{0}'' did not return a valid response.<br>It is likely that ''{0}'' is not an OSM API server.<br>Please check the spelling of ''{0}'' and validate again.</html>", this.getNormalizedApiUrl()), I18n.tr("Connection to API failed"), 0, HelpUtil.ht("/Preferences/Connection#InvalidSettings"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        ApiUrlTestTask apiUrlTestTask = this;
        synchronized (apiUrlTestTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    protected void finish() {
    }

    protected String getNormalizedApiUrl() {
        String apiUrl = this.url.trim();
        while (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.lastIndexOf("/"));
        }
        return apiUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        BufferedReader bin = null;
        try {
            String line;
            URL capabilitiesUrl;
            try {
                new URL(this.getNormalizedApiUrl());
            }
            catch (MalformedURLException e) {
                this.alertInvalidUrl(this.getNormalizedApiUrl());
                if (bin == null) return;
                try {
                    bin.close();
                    return;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
            }
            String getChangesetsUrl = this.getNormalizedApiUrl() + "/0.6/changesets";
            try {
                capabilitiesUrl = new URL(getChangesetsUrl);
            }
            catch (MalformedURLException e) {
                this.alertInvalidChangesetUrl(getChangesetsUrl);
                if (bin == null) return;
                try {
                    bin.close();
                    return;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                return;
            }
            ApiUrlTestTask e = this;
            synchronized (e) {
                this.connection = (HttpURLConnection)capabilitiesUrl.openConnection();
            }
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.setRequestMethod("GET");
            this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
            this.connection.setRequestProperty("Host", this.connection.getURL().getHost());
            this.connection.connect();
            if (this.connection.getResponseCode() != 200) {
                this.alertInvalidServerResult(this.connection.getResponseCode());
                return;
            }
            StringBuilder changesets = new StringBuilder();
            bin = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            while ((line = bin.readLine()) != null) {
                changesets.append(line).append("\n");
            }
            if (!changesets.toString().contains("<osm") || !changesets.toString().contains("</osm>")) {
                this.alertInvalidChangesetList();
                return;
            }
            this.success = true;
            return;
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            e.printStackTrace();
            this.alertConnectionFailed();
            return;
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

