/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OAuthAuthenticationPreferencesPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(OAuthAuthenticationPreferencesPanel.class.getName());
    private JPanel pnlAuthorisationMessage;
    private NotYetAuthorisedPanel pnlNotYetAuthorised;
    private AlreadyAuthorisedPanel pnlAlreadyAuthorised;
    private AdvancedOAuthPropertiesPanel pnlAdvancedProperties;
    private String apiUrl;
    private JCheckBox cbShowAdvancedParameters;
    private JCheckBox cbSaveToPreferences;

    protected JPanel buildAdvancedPropertiesPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        this.cbShowAdvancedParameters = new JCheckBox();
        pnl.add((Component)this.cbShowAdvancedParameters, gc);
        this.cbShowAdvancedParameters.setSelected(false);
        this.cbShowAdvancedParameters.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setVisible(evt.getStateChange() == 1);
            }
        });
        gc.gridx = 1;
        gc.weightx = 1.0;
        JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Display Advanced OAuth Parameters"));
        lbl.setFont(lbl.getFont().deriveFont(0));
        pnl.add((Component)lbl, gc);
        gc.gridy = 1;
        gc.gridx = 1;
        gc.insets = new Insets(3, 0, 3, 0);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel();
        pnl.add((Component)this.pnlAdvancedProperties, gc);
        this.pnlAdvancedProperties.initFromPreferences(Main.pref);
        this.pnlAdvancedProperties.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.pnlAdvancedProperties.setVisible(false);
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.anchor = 18;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.insets = new Insets(10, 0, 0, 0);
        this.pnlAuthorisationMessage = new JPanel();
        this.add((Component)this.pnlAuthorisationMessage, gc);
        this.pnlAuthorisationMessage.setLayout(new BorderLayout());
        this.pnlAlreadyAuthorised = new AlreadyAuthorisedPanel();
        this.pnlNotYetAuthorised = new NotYetAuthorisedPanel();
    }

    protected void refreshView() {
        this.pnlAuthorisationMessage.removeAll();
        if (OAuthAccessTokenHolder.getInstance().containsAccessToken()) {
            this.pnlAuthorisationMessage.add((Component)this.pnlAlreadyAuthorised, "Center");
            this.pnlAlreadyAuthorised.refreshView();
            this.pnlAlreadyAuthorised.revalidate();
        } else {
            this.pnlAuthorisationMessage.add((Component)this.pnlNotYetAuthorised, "Center");
            this.pnlNotYetAuthorised.revalidate();
        }
        this.repaint();
    }

    public OAuthAuthenticationPreferencesPanel() {
        this.build();
        this.refreshView();
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void initFromPreferences() {
        this.refreshView();
    }

    public void saveToPreferences() {
        OAuthAccessTokenHolder.getInstance().setSaveToPreferences(this.cbSaveToPreferences.isSelected());
        OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManagerFactory.getCredentialManager());
        this.pnlAdvancedProperties.getAdvancedParameters().saveToPreferences(Main.pref);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(OsmApiUrlInputPanel.API_URL_PROP)) {
            return;
        }
        this.apiUrl = (String)evt.getNewValue();
    }

    private class TestAuthorisationAction
    extends AbstractAction {
        public TestAuthorisationAction() {
            this.putValue("Name", I18n.tr("Test Access Token"));
            this.putValue("ShortDescription", I18n.tr("Click test access to the OSM server with the current access token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
        }

        public void actionPerformed(ActionEvent evt) {
            OAuthToken token = OAuthAccessTokenHolder.getInstance().getAccessToken();
            OAuthParameters parameters = OAuthParameters.createFromPreferences(Main.pref);
            TestAccessTokenTask task = new TestAccessTokenTask(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, parameters, token);
            Main.worker.submit(task);
        }
    }

    private class RenewAuthorisationAction
    extends AbstractAction {
        public RenewAuthorisationAction() {
            this.putValue("Name", I18n.tr("New Access Token"));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process and generate a new Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
        }

        public void actionPerformed(ActionEvent arg0) {
            OAuthAuthorizationWizard wizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl);
            wizard.setVisible(true);
            if (wizard.isCanceled()) {
                return;
            }
            OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
            holder.setAccessToken(wizard.getAccessToken());
            holder.setSaveToPreferences(wizard.isSaveAccessTokenToPreferences());
            OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(wizard.getOAuthParameters());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AuthoriseNowAction
    extends AbstractAction {
        public AuthoriseNowAction() {
            this.putValue("Name", I18n.tr("Authorize now"));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
        }

        public void actionPerformed(ActionEvent arg0) {
            OAuthAuthorizationWizard wizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl);
            wizard.setVisible(true);
            if (wizard.isCanceled()) {
                return;
            }
            OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
            holder.setAccessToken(wizard.getAccessToken());
            holder.setSaveToPreferences(wizard.isSaveAccessTokenToPreferences());
            OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(wizard.getOAuthParameters());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AlreadyAuthorisedPanel
    extends JPanel {
        private JTextField tfAccessTokenKey;
        private JTextField tfAccessTokenSecret;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 3, 3);
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("You already have an Access Token to access the OSM server using OAuth."));
            this.add((Component)lbl, gc);
            lbl.setFont(lbl.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Key:")), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.tfAccessTokenKey = new JTextField();
            this.add((Component)this.tfAccessTokenKey, gc);
            this.tfAccessTokenKey.setEditable(false);
            gc.gridy = 2;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Secret:")), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.tfAccessTokenSecret = new JTextField();
            this.add((Component)this.tfAccessTokenSecret, gc);
            this.tfAccessTokenSecret.setEditable(false);
            gc.gridy = 3;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)(OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences = new JCheckBox(I18n.tr("Save to preferences"))), gc);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            JPanel btns = new JPanel(new FlowLayout(0));
            btns.add(new SideButton(new RenewAuthorisationAction()));
            btns.add(new SideButton(new TestAuthorisationAction()));
            gc.gridy = 4;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)btns, gc);
            gc.gridy = 5;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.buildAdvancedPropertiesPanel(), gc);
            gc.gridy = 6;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        public void refreshView() {
            String v = OAuthAccessTokenHolder.getInstance().getAccessTokenKey();
            this.tfAccessTokenKey.setText(v == null ? "" : v);
            v = OAuthAccessTokenHolder.getInstance().getAccessTokenSecret();
            this.tfAccessTokenSecret.setText(v == null ? "" : v);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        }

        public AlreadyAuthorisedPanel() {
            this.build();
            this.refreshView();
        }
    }

    private class NotYetAuthorisedPanel
    extends JPanel {
        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 3, 0);
            gc.fill = 2;
            gc.weightx = 1.0;
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("You do not have an Access Token yet to access the OSM server using OAuth. Please authorize first."));
            this.add((Component)lbl, gc);
            lbl.setFont(lbl.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            this.add((Component)new SideButton(new AuthoriseNowAction()), gc);
            gc.gridy = 2;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        public NotYetAuthorisedPanel() {
            this.build();
        }
    }
}

