/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionManager
implements DataSetListener {
    protected boolean dirty;
    protected DataSet ds;
    protected MultiMap<String, String> tagCache;
    protected static MultiMap<String, String> presetTagCache = new MultiMap();
    protected Set<String> roleCache;
    protected static Set<String> presetRoleCache = new HashSet<String>();

    public AutoCompletionManager(DataSet ds) {
        this.ds = ds;
        this.dirty = true;
    }

    protected MultiMap<String, String> getTagCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.tagCache;
    }

    protected Set<String> getRoleCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.roleCache;
    }

    protected void rebuild() {
        this.tagCache = new MultiMap();
        this.roleCache = new HashSet<String>();
        this.cachePrimitives(this.ds.allNonDeletedCompletePrimitives());
    }

    protected void cachePrimitives(Collection<? extends OsmPrimitive> primitives) {
        for (OsmPrimitive osmPrimitive : primitives) {
            this.cachePrimitiveTags(osmPrimitive);
            if (!(osmPrimitive instanceof Relation)) continue;
            this.cacheRelationMemberRoles((Relation)osmPrimitive);
        }
    }

    protected void cachePrimitiveTags(OsmPrimitive primitive) {
        for (String key : primitive.keySet()) {
            String value = primitive.get(key);
            this.tagCache.put(key, value);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember m : relation.getMembers()) {
            if (!m.hasRole()) continue;
            this.roleCache.add(m.getRole());
        }
    }

    public static void cachePresets(Collection<TaggingPreset> presets) {
        for (TaggingPreset p : presets) {
            for (TaggingPreset.Item item : p.data) {
                if (item instanceof TaggingPreset.Check) {
                    TaggingPreset.Check ch = (TaggingPreset.Check)item;
                    if (ch.key == null) continue;
                    presetTagCache.put(ch.key, "no");
                    presetTagCache.put(ch.key, "yes");
                    continue;
                }
                if (item instanceof TaggingPreset.Combo) {
                    TaggingPreset.Combo co = (TaggingPreset.Combo)item;
                    if (co.key == null || co.values == null) continue;
                    for (String value : co.values.split(",")) {
                        presetTagCache.put(co.key, value);
                    }
                    continue;
                }
                if (item instanceof TaggingPreset.Key) {
                    TaggingPreset.Key ky = (TaggingPreset.Key)item;
                    if (ky.key == null || ky.value == null) continue;
                    presetTagCache.put(ky.key, ky.value);
                    continue;
                }
                if (item instanceof TaggingPreset.Text) {
                    TaggingPreset.Text tt = (TaggingPreset.Text)item;
                    if (tt.key == null) continue;
                    presetTagCache.putVoid(tt.key);
                    if (tt.default_ == null || tt.default_.equals("")) continue;
                    presetTagCache.put(tt.key, tt.default_);
                    continue;
                }
                if (!(item instanceof TaggingPreset.Roles)) continue;
                TaggingPreset.Roles r = (TaggingPreset.Roles)item;
                for (TaggingPreset.Role i : r.roles) {
                    if (i.key == null) continue;
                    presetRoleCache.add(i.key);
                }
            }
        }
    }

    protected List<String> getDataKeys() {
        return new ArrayList<String>(this.getTagCache().keySet());
    }

    protected List<String> getPresetKeys() {
        return new ArrayList<String>(presetTagCache.keySet());
    }

    protected List<String> getDataValues(String key) {
        return new ArrayList<String>(this.getTagCache().getValues(key));
    }

    protected static List<String> getPresetValues(String key) {
        return new ArrayList<String>(presetTagCache.getValues(key));
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.getRoleCache());
    }

    public void populateWithMemberRoles(AutoCompletionList list) {
        list.add(presetRoleCache, AutoCompletionItemPritority.IS_IN_STANDARD);
        list.add(this.getRoleCache(), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithKeys(AutoCompletionList list) {
        list.add(this.getPresetKeys(), AutoCompletionItemPritority.IS_IN_STANDARD);
        list.add(this.getDataKeys(), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithTagValues(AutoCompletionList list, String key) {
        list.add(AutoCompletionManager.getPresetValues(key), AutoCompletionItemPritority.IS_IN_STANDARD);
        list.add(this.getDataValues(key), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public List<AutoCompletionListItem> getKeys() {
        AutoCompletionList list = new AutoCompletionList();
        this.populateWithKeys(list);
        return new ArrayList<AutoCompletionListItem>(list.getList());
    }

    public List<AutoCompletionListItem> getValues(String key) {
        AutoCompletionList list = new AutoCompletionList();
        this.populateWithTagValues(list, key);
        return new ArrayList<AutoCompletionListItem>(list.getList());
    }

    @Override
    public void primtivesAdded(PrimitivesAddedEvent event) {
        if (this.dirty) {
            return;
        }
        this.cachePrimitives(event.getPrimitives());
    }

    @Override
    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        this.dirty = true;
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        if (this.dirty) {
            return;
        }
        Map<String, String> newKeys = event.getPrimitive().getKeys();
        Map<String, String> oldKeys = event.getOriginalKeys();
        if (!newKeys.keySet().containsAll(oldKeys.keySet())) {
            this.dirty = true;
        } else {
            for (Map.Entry<String, String> oldEntry : oldKeys.entrySet()) {
                if (oldEntry.getValue().equals(newKeys.get(oldEntry.getKey()))) continue;
                this.dirty = true;
                return;
            }
            this.cachePrimitives(Collections.singleton(event.getPrimitive()));
        }
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.dirty = true;
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.dirty = true;
    }
}

