/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmChangesetParser {
    private static final Logger logger = Logger.getLogger(OsmChangesetParser.class.getName());
    private List<Changeset> changesets = new LinkedList<Changeset>();

    private OsmChangesetParser() {
    }

    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public static List<Changeset> parse(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        OsmChangesetParser parser = new OsmChangesetParser();
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing list of changesets..."));
            InputSource inputSource = new InputSource(new InputStreamReader(source, "UTF-8"));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmChangesetParser osmChangesetParser = parser;
            osmChangesetParser.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmChangesetParser.new Parser());
            List<Changeset> list = parser.getChangesets();
            return list;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalDataException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private Changeset current = null;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws OsmDataParsingException {
            throw new OsmDataParsingException(msg).rememberLocation(this.locator);
        }

        protected void parseChangesetAttributes(Changeset cs, Attributes atts) throws OsmDataParsingException {
            String value = atts.getValue("id");
            if (value == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "id"));
            }
            int id = 0;
            try {
                id = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "id", value));
            }
            if (id <= 0) {
                this.throwException(I18n.tr("Illegal numeric value for attribute ''{0}''. Got ''{1}''.", "id", id));
            }
            this.current.setId(id);
            String user = atts.getValue("user");
            String uid = atts.getValue("uid");
            this.current.setUser(this.createUser(uid, user));
            value = atts.getValue("created_at");
            if (value == null) {
                this.current.setCreatedAt(null);
            } else {
                this.current.setCreatedAt(DateUtils.fromString(value));
            }
            value = atts.getValue("closed_at");
            if (value == null) {
                this.current.setClosedAt(null);
            } else {
                this.current.setClosedAt(DateUtils.fromString(value));
            }
            value = atts.getValue("open");
            if (value == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "open"));
            } else if (value.equals("true")) {
                this.current.setOpen(true);
            } else if (value.equals("false")) {
                this.current.setOpen(false);
            } else {
                this.throwException(I18n.tr("Illegal boolean value for attribute ''{0}''. Got ''{1}''.", "open", value));
            }
            String min_lon = atts.getValue("min_lon");
            String min_lat = atts.getValue("min_lat");
            String max_lon = atts.getValue("max_lon");
            String max_lat = atts.getValue("max_lat");
            if (min_lon != null && min_lat != null && max_lon != null && max_lat != null) {
                double minLon = 0.0;
                try {
                    minLon = Double.parseDouble(min_lon);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lon", min_lon));
                }
                double minLat = 0.0;
                try {
                    minLat = Double.parseDouble(min_lat);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lat", min_lat));
                }
                this.current.setMin(new LatLon(minLat, minLon));
                double maxLon = 0.0;
                try {
                    maxLon = Double.parseDouble(max_lon);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lon", max_lon));
                }
                double maxLat = 0.0;
                try {
                    maxLat = Double.parseDouble(max_lat);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lat", max_lat));
                }
                this.current.setMax(new LatLon(maxLon, maxLat));
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("osm")) {
                String v;
                if (atts == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                }
                if ((v = atts.getValue("version")) == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                }
                if (!v.equals("0.6")) {
                    this.throwException(I18n.tr("Unsupported version: {0}", v));
                }
            } else if (qName.equals("changeset")) {
                this.current = new Changeset();
                this.parseChangesetAttributes(this.current, atts);
            } else if (qName.equals("tag")) {
                String key = atts.getValue("k");
                String value = atts.getValue("v");
                this.current.put(key, value);
            } else {
                this.throwException(I18n.tr("Undefined element ''{0}'' found in input stream. Aborting.", qName));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("changeset")) {
                OsmChangesetParser.this.changesets.add(this.current);
            }
        }

        protected User createUser(String uid, String name) throws OsmDataParsingException {
            if (uid == null) {
                if (name == null) {
                    return null;
                }
                return User.createLocalUser(name);
            }
            try {
                long id = Long.parseLong(uid);
                return User.createOsmUser(id, name);
            }
            catch (NumberFormatException e) {
                this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", uid));
                return null;
            }
        }
    }
}

