/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class CheckParameterUtil {
    private CheckParameterUtil() {
    }

    public static void ensureValidPrimitiveId(PrimitiveId id, String parameterName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(id, parameterName);
        if (id.getUniqueId() <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected unique id > 0 for primitive ''{1}'', got {0}", id.getUniqueId(), parameterName));
        }
    }

    public static void ensureValidVersion(long version, String parameterName) throws IllegalArgumentException {
        if (version < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type long > 0 for parameter ''{0}'', got {1}", parameterName, version));
        }
    }

    public static void ensureParameterNotNull(Object value, String parameterName) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be null", parameterName));
        }
    }

    public static void ensureValidNodeId(PrimitiveId id, String parameterName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(id, parameterName);
        if (!id.getType().equals((Object)OsmPrimitiveType.NODE)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' of type node expected, got ''{1}''", parameterName, id.getType().getAPIName()));
        }
    }
}

