/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior.iiop;

import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.impl.ior.EncapsulationUtility;
import com.sun.corba.se.impl.ior.iiop.IIOPAddressImpl;
import com.sun.corba.se.spi.ior.ObjectId;
import com.sun.corba.se.spi.ior.ObjectKeyTemplate;
import com.sun.corba.se.spi.ior.TaggedProfile;
import com.sun.corba.se.spi.ior.TaggedProfileTemplate;
import com.sun.corba.se.spi.ior.TaggedProfileTemplateBase;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPProfileTemplateImpl
extends TaggedProfileTemplateBase
implements IIOPProfileTemplate {
    private ORB orb;
    private GIOPVersion giopVersion;
    private IIOPAddress primary;

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IIOPProfileTemplateImpl)) {
            return false;
        }
        IIOPProfileTemplateImpl iIOPProfileTemplateImpl = (IIOPProfileTemplateImpl)object;
        return super.equals(object) && this.giopVersion.equals(iIOPProfileTemplateImpl.giopVersion) && this.primary.equals(iIOPProfileTemplateImpl.primary);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.giopVersion.hashCode() ^ this.primary.hashCode();
    }

    @Override
    public TaggedProfile create(ObjectKeyTemplate objectKeyTemplate, ObjectId objectId) {
        return IIOPFactories.makeIIOPProfile(this.orb, objectKeyTemplate, objectId, this);
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return this.giopVersion;
    }

    @Override
    public IIOPAddress getPrimaryAddress() {
        return this.primary;
    }

    public IIOPProfileTemplateImpl(ORB oRB, GIOPVersion gIOPVersion, IIOPAddress iIOPAddress) {
        this.orb = oRB;
        this.giopVersion = gIOPVersion;
        this.primary = iIOPAddress;
        if (this.giopVersion.getMinor() == 0) {
            this.makeImmutable();
        }
    }

    public IIOPProfileTemplateImpl(InputStream inputStream) {
        byte by = inputStream.read_octet();
        byte by2 = inputStream.read_octet();
        this.giopVersion = GIOPVersion.getInstance(by, by2);
        this.primary = new IIOPAddressImpl(inputStream);
        this.orb = (ORB)inputStream.orb();
        if (by2 > 0) {
            EncapsulationUtility.readIdentifiableSequence(this, this.orb.getTaggedComponentFactoryFinder(), inputStream);
        }
        this.makeImmutable();
    }

    @Override
    public void write(ObjectKeyTemplate objectKeyTemplate, ObjectId objectId, OutputStream outputStream) {
        this.giopVersion.write(outputStream);
        this.primary.write(outputStream);
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream((ORB)outputStream.orb(), ((CDROutputStream)outputStream).isLittleEndian());
        objectKeyTemplate.write(objectId, encapsOutputStream);
        EncapsulationUtility.writeOutputStream(encapsOutputStream, outputStream);
        if (this.giopVersion.getMinor() > 0) {
            EncapsulationUtility.writeIdentifiableSequence(this, outputStream);
        }
    }

    @Override
    public void writeContents(OutputStream outputStream) {
        this.giopVersion.write(outputStream);
        this.primary.write(outputStream);
        if (this.giopVersion.getMinor() > 0) {
            EncapsulationUtility.writeIdentifiableSequence(this, outputStream);
        }
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public boolean isEquivalent(TaggedProfileTemplate taggedProfileTemplate) {
        if (!(taggedProfileTemplate instanceof IIOPProfileTemplateImpl)) {
            return false;
        }
        IIOPProfileTemplateImpl iIOPProfileTemplateImpl = (IIOPProfileTemplateImpl)taggedProfileTemplate;
        return this.primary.equals(iIOPProfileTemplateImpl.primary);
    }
}

