/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileRef;
import java.nio.file.FileTreeWalker;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.Attributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import sun.nio.fs.DefaultFileTypeDetector;

public final class Files {
    private Files() {
    }

    public static String probeContentType(FileRef fileRef) throws IOException {
        for (FileTypeDetector fileTypeDetector : DefaultFileTypeDetectorHolder.installeDetectors) {
            String string = fileTypeDetector.probeContentType(fileRef);
            if (string == null) continue;
            return string;
        }
        return DefaultFileTypeDetectorHolder.defaultFileTypeDetector.probeContentType(fileRef);
    }

    public static void walkFileTree(Path path, Set<FileVisitOption> set, int n, FileVisitor<? super Path> fileVisitor) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        new FileTreeWalker(set, fileVisitor, n).walk(path);
    }

    public static void walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) throws IOException {
        Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, fileVisitor);
    }

    public static void createDirectories(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        try {
            Files.createAndCheckIsDirectory(path, fileAttributeArray);
            return;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw fileAlreadyExistsException;
        }
        catch (IOException iOException) {
            Path path2;
            SecurityException securityException = null;
            try {
                path = path.toAbsolutePath();
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
            for (path2 = path.getParent(); path2 != null; path2 = path2.getParent()) {
                try {
                    path2.checkAccess(new AccessMode[0]);
                    break;
                }
                catch (NoSuchFileException noSuchFileException) {
                    continue;
                }
            }
            if (path2 == null) {
                if (securityException != null) {
                    throw securityException;
                }
                throw new IOException("Root directory does not exist");
            }
            Path path3 = path2;
            for (Path path4 : path2.relativize(path)) {
                path3 = path3.resolve(path4);
                Files.createAndCheckIsDirectory(path3, fileAttributeArray);
            }
            return;
        }
    }

    private static void createAndCheckIsDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        block2: {
            try {
                path.createDirectory(fileAttributeArray);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                boolean bl = Attributes.readBasicFileAttributes(path, LinkOption.NOFOLLOW_LINKS).isDirectory();
                if (bl) break block2;
                throw fileAlreadyExistsException;
            }
        }
    }

    private static class DefaultFileTypeDetectorHolder {
        static final FileTypeDetector defaultFileTypeDetector = DefaultFileTypeDetector.create();
        static final List<FileTypeDetector> installeDetectors = DefaultFileTypeDetectorHolder.loadInstalledDetectors();

        private DefaultFileTypeDetectorHolder() {
        }

        private static List<FileTypeDetector> loadInstalledDetectors() {
            return AccessController.doPrivileged(new PrivilegedAction<List<FileTypeDetector>>(){

                @Override
                public List<FileTypeDetector> run() {
                    ArrayList<FileTypeDetector> arrayList = new ArrayList<FileTypeDetector>();
                    ServiceLoader<FileTypeDetector> serviceLoader = ServiceLoader.load(FileTypeDetector.class, ClassLoader.getSystemClassLoader());
                    for (FileTypeDetector fileTypeDetector : serviceLoader) {
                        arrayList.add(fileTypeDetector);
                    }
                    return arrayList;
                }
            });
        }
    }
}

