/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.SignerOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMHMACSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMSignatureMethod
extends DOMStructure
implements SignatureMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    static final String RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    static final String RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    static final String RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    static final String HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    static final String HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    static final String HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    private SignatureMethodParameterSpec params;
    private Signature signature;

    DOMSignatureMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof SignatureMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type SignatureMethodParameterSpec");
        }
        this.checkParams((SignatureMethodParameterSpec)algorithmParameterSpec);
        this.params = (SignatureMethodParameterSpec)algorithmParameterSpec;
    }

    DOMSignatureMethod(Element element) throws MarshalException {
        Element element2 = DOMUtils.getFirstChildElement(element);
        if (element2 != null) {
            this.params = this.unmarshalParams(element2);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    static SignatureMethod unmarshal(Element element) throws MarshalException {
        String string = DOMUtils.getAttributeValue(element, "Algorithm");
        if (string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return new SHA1withRSA(element);
        }
        if (string.equals(RSA_SHA256)) {
            return new SHA256withRSA(element);
        }
        if (string.equals(RSA_SHA384)) {
            return new SHA384withRSA(element);
        }
        if (string.equals(RSA_SHA512)) {
            return new SHA512withRSA(element);
        }
        if (string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return new SHA1withDSA(element);
        }
        if (string.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            return new DOMHMACSignatureMethod.SHA1(element);
        }
        if (string.equals(HMAC_SHA256)) {
            return new DOMHMACSignatureMethod.SHA256(element);
        }
        if (string.equals(HMAC_SHA384)) {
            return new DOMHMACSignatureMethod.SHA384(element);
        }
        if (string.equals(HMAC_SHA512)) {
            return new DOMHMACSignatureMethod.SHA512(element);
        }
        throw new MarshalException("unsupported SignatureMethod algorithm: " + string);
    }

    void checkParams(SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (signatureMethodParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for the " + this.getSignatureAlgorithm() + " SignatureMethod algorithm");
        }
    }

    @Override
    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    SignatureMethodParameterSpec unmarshalParams(Element element) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getSignatureAlgorithm() + " SignatureMethod algorithm");
    }

    @Override
    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "SignatureMethod", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMUtils.setAttribute(element, "Algorithm", this.getAlgorithm());
        if (this.params != null) {
            this.marshalParams(element, string);
        }
        node.appendChild(element);
    }

    boolean verify(Key key, DOMSignedInfo dOMSignedInfo, byte[] byArray, XMLValidateContext xMLValidateContext) throws InvalidKeyException, SignatureException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null || byArray == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this.signature == null) {
            try {
                Provider provider = (Provider)xMLValidateContext.getProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider");
                this.signature = provider == null ? Signature.getInstance(this.getSignatureAlgorithm()) : Signature.getInstance(this.getSignatureAlgorithm(), provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.signature.initVerify((PublicKey)key);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signature provider:" + this.signature.getProvider());
            log.log(Level.FINE, "verifying with key: " + key);
        }
        dOMSignedInfo.canonicalize(xMLValidateContext, new SignerOutputStream(this.signature));
        if (this.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            try {
                return this.signature.verify(DOMSignatureMethod.convertXMLDSIGtoASN1(byArray));
            }
            catch (IOException iOException) {
                throw new XMLSignatureException(iOException);
            }
        }
        return this.signature.verify(byArray);
    }

    byte[] sign(Key key, DOMSignedInfo dOMSignedInfo, XMLSignContext xMLSignContext) throws InvalidKeyException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                Provider provider = (Provider)xMLSignContext.getProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider");
                this.signature = provider == null ? Signature.getInstance(this.getSignatureAlgorithm()) : Signature.getInstance(this.getSignatureAlgorithm(), provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.signature.initSign((PrivateKey)key);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signature provider:" + this.signature.getProvider());
            log.log(Level.FINE, "Signing with key: " + key);
        }
        dOMSignedInfo.canonicalize(xMLSignContext, new SignerOutputStream(this.signature));
        try {
            if (this.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return DOMSignatureMethod.convertASN1toXMLDSIG(this.signature.sign());
            }
            return this.signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
    }

    void marshalParams(Element element, String string) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getSignatureAlgorithm() + " SignatureMethod algorithm");
    }

    abstract String getSignatureAlgorithm();

    boolean paramsEqual(AlgorithmParameterSpec algorithmParameterSpec) {
        return this.getParameterSpec() == algorithmParameterSpec;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignatureMethod)) {
            return false;
        }
        SignatureMethod signatureMethod = (SignatureMethod)object;
        return this.getAlgorithm().equals(signatureMethod.getAlgorithm()) && this.paramsEqual(signatureMethod.getParameterSpec());
    }

    private static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = n3 = byArray[3]; n4 > 0 && byArray[4 + n3 - n4] == 0; --n4) {
        }
        for (n2 = n = byArray[5 + n3]; n2 > 0 && byArray[6 + n3 + n - n2] == 0; --n2) {
        }
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2 || n4 > 20 || byArray[4 + n3] != 2 || n2 > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] byArray2 = new byte[40];
        System.arraycopy(byArray, 4 + n3 - n4, byArray2, 20 - n4, n4);
        System.arraycopy(byArray, 6 + n3 + n - n2, byArray2, 40 - n2, n2);
        return byArray2;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        int n;
        int n2;
        if (byArray.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        for (n2 = 20; n2 > 0 && byArray[20 - n2] == 0; --n2) {
        }
        int n3 = n2;
        if (byArray[20 - n2] < 0) {
            ++n3;
        }
        for (n = 20; n > 0 && byArray[40 - n] == 0; --n) {
        }
        int n4 = n;
        if (byArray[40 - n] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[6 + n3 + n4];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n3 + n4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n3;
        System.arraycopy(byArray, 20 - n2, byArray2, 4 + n3 - n2, n2);
        byArray2[4 + n3] = 2;
        byArray2[5 + n3] = (byte)n4;
        System.arraycopy(byArray, 40 - n, byArray2, 6 + n3 + n4 - n, n);
        return byArray2;
    }

    static final class SHA1withDSA
    extends DOMSignatureMethod {
        SHA1withDSA(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA1withDSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        public String getAlgorithm() {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }

        @Override
        String getSignatureAlgorithm() {
            return "SHA1withDSA";
        }
    }

    static final class SHA512withRSA
    extends DOMSignatureMethod {
        SHA512withRSA(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA512withRSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        public String getAlgorithm() {
            return DOMSignatureMethod.RSA_SHA512;
        }

        @Override
        String getSignatureAlgorithm() {
            return "SHA512withRSA";
        }
    }

    static final class SHA384withRSA
    extends DOMSignatureMethod {
        SHA384withRSA(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA384withRSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        public String getAlgorithm() {
            return DOMSignatureMethod.RSA_SHA384;
        }

        @Override
        String getSignatureAlgorithm() {
            return "SHA384withRSA";
        }
    }

    static final class SHA256withRSA
    extends DOMSignatureMethod {
        SHA256withRSA(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA256withRSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        public String getAlgorithm() {
            return DOMSignatureMethod.RSA_SHA256;
        }

        @Override
        String getSignatureAlgorithm() {
            return "SHA256withRSA";
        }
    }

    static final class SHA1withRSA
    extends DOMSignatureMethod {
        SHA1withRSA(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA1withRSA(Element element) throws MarshalException {
            super(element);
        }

        @Override
        public String getAlgorithm() {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }

        @Override
        String getSignatureAlgorithm() {
            return "SHA1withRSA";
        }
    }
}

