/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import sun.font.Font2D;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.NullFontScaler;
import sun.font.StrikeMetrics;
import sun.font.Type1Font;

class FreetypeFontScaler
extends FontScaler {
    private static final int TRUETYPE_FONT = 1;
    private static final int TYPE1_FONT = 2;

    private static native void initIDs(Class var0);

    private void invalidateScaler() throws FontScalerException {
        this.nativeScaler = 0L;
        this.font = null;
        throw new FontScalerException();
    }

    public FreetypeFontScaler(Font2D font2D, int n, boolean bl, int n2) {
        int n3 = 1;
        if (font2D instanceof Type1Font) {
            n3 = 2;
        }
        this.nativeScaler = this.initNativeScaler(font2D, n3, n, bl, n2);
        this.font = new WeakReference<Font2D>(font2D);
    }

    @Override
    synchronized StrikeMetrics getFontMetrics(long l) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getFontMetricsNative((Font2D)this.font.get(), l, this.nativeScaler);
        }
        return FontScaler.getNullScaler().getFontMetrics(0L);
    }

    @Override
    synchronized float getGlyphAdvance(long l, int n) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphAdvanceNative((Font2D)this.font.get(), l, this.nativeScaler, n);
        }
        return FontScaler.getNullScaler().getGlyphAdvance(0L, n);
    }

    @Override
    synchronized void getGlyphMetrics(long l, int n, Point2D.Float float_) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            this.getGlyphMetricsNative((Font2D)this.font.get(), l, this.nativeScaler, n, float_);
            return;
        }
        FontScaler.getNullScaler().getGlyphMetrics(0L, n, float_);
    }

    @Override
    synchronized long getGlyphImage(long l, int n) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphImageNative((Font2D)this.font.get(), l, this.nativeScaler, n);
        }
        return FontScaler.getNullScaler().getGlyphImage(0L, n);
    }

    @Override
    synchronized Rectangle2D.Float getGlyphOutlineBounds(long l, int n) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphOutlineBoundsNative((Font2D)this.font.get(), l, this.nativeScaler, n);
        }
        return FontScaler.getNullScaler().getGlyphOutlineBounds(0L, n);
    }

    @Override
    synchronized GeneralPath getGlyphOutline(long l, int n, float f, float f2) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphOutlineNative((Font2D)this.font.get(), l, this.nativeScaler, n, f, f2);
        }
        return FontScaler.getNullScaler().getGlyphOutline(0L, n, f, f2);
    }

    @Override
    synchronized GeneralPath getGlyphVectorOutline(long l, int[] nArray, int n, float f, float f2) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphVectorOutlineNative((Font2D)this.font.get(), l, this.nativeScaler, nArray, n, f, f2);
        }
        return FontScaler.getNullScaler().getGlyphVectorOutline(0L, nArray, n, f, f2);
    }

    @Override
    synchronized long getLayoutTableCache() throws FontScalerException {
        return this.getLayoutTableCacheNative(this.nativeScaler);
    }

    @Override
    public synchronized void dispose() {
        if (this.nativeScaler != 0L) {
            this.disposeNativeScaler(this.nativeScaler);
            this.nativeScaler = 0L;
        }
    }

    @Override
    synchronized int getNumGlyphs() throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getNumGlyphsNative(this.nativeScaler);
        }
        return FontScaler.getNullScaler().getNumGlyphs();
    }

    @Override
    synchronized int getMissingGlyphCode() throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getMissingGlyphCodeNative(this.nativeScaler);
        }
        return FontScaler.getNullScaler().getMissingGlyphCode();
    }

    @Override
    synchronized int getGlyphCode(char c) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphCodeNative(this.nativeScaler, c);
        }
        return FontScaler.getNullScaler().getGlyphCode(c);
    }

    @Override
    synchronized Point2D.Float getGlyphPoint(long l, int n, int n2) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphPointNative((Font2D)this.font.get(), l, this.nativeScaler, n, n2);
        }
        return FontScaler.getNullScaler().getGlyphPoint(l, n, n2);
    }

    @Override
    synchronized long getUnitsPerEm() {
        return this.getUnitsPerEMNative(this.nativeScaler);
    }

    @Override
    long createScalerContext(double[] dArray, boolean bl, int n, int n2, float f, float f2) {
        if (this.nativeScaler != 0L) {
            return this.createScalerContextNative(this.nativeScaler, dArray, bl, n, n2, f, f2);
        }
        return NullFontScaler.getNullScalerContext();
    }

    private native long initNativeScaler(Font2D var1, int var2, int var3, boolean var4, int var5);

    private native StrikeMetrics getFontMetricsNative(Font2D var1, long var2, long var4);

    private native float getGlyphAdvanceNative(Font2D var1, long var2, long var4, int var6);

    private native void getGlyphMetricsNative(Font2D var1, long var2, long var4, int var6, Point2D.Float var7);

    private native long getGlyphImageNative(Font2D var1, long var2, long var4, int var6);

    private native Rectangle2D.Float getGlyphOutlineBoundsNative(Font2D var1, long var2, long var4, int var6);

    private native GeneralPath getGlyphOutlineNative(Font2D var1, long var2, long var4, int var6, float var7, float var8);

    private native GeneralPath getGlyphVectorOutlineNative(Font2D var1, long var2, long var4, int[] var6, int var7, float var8, float var9);

    native Point2D.Float getGlyphPointNative(Font2D var1, long var2, long var4, int var6, int var7);

    private native long getLayoutTableCacheNative(long var1);

    private native void disposeNativeScaler(long var1);

    private native int getGlyphCodeNative(long var1, char var3);

    private native int getNumGlyphsNative(long var1);

    private native int getMissingGlyphCodeNative(long var1);

    private native long getUnitsPerEMNative(long var1);

    native long createScalerContextNative(long var1, double[] var3, boolean var4, int var5, int var6, float var7, float var8);

    @Override
    void invalidateScalerContext(long l) {
    }

    static {
        FontManagerNativeLibrary.load();
        FreetypeFontScaler.initIDs(FreetypeFontScaler.class);
    }
}

