/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.ShapeDrawPipe;

public class PixelToParallelogramConverter
extends PixelToShapeConverter
implements ShapeDrawPipe {
    ParallelogramPipe outrenderer;
    double minPenSize;
    double normPosition;
    double normRoundingBias;
    boolean adjustfill;

    public PixelToParallelogramConverter(ShapeDrawPipe shapeDrawPipe, ParallelogramPipe parallelogramPipe, double d, double d2, boolean bl) {
        super(shapeDrawPipe);
        this.outrenderer = parallelogramPipe;
        this.minPenSize = d;
        this.normPosition = d2;
        this.normRoundingBias = 0.5 - d2;
        this.adjustfill = bl;
    }

    @Override
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (!this.drawGeneralLine(sunGraphics2D, n, n2, n3, n4)) {
            super.drawLine(sunGraphics2D, n, n2, n3, n4);
        }
    }

    @Override
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (n3 >= 0 && n4 >= 0) {
            if (sunGraphics2D.strokeState < 3) {
                BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
                if (n3 > 0 && n4 > 0) {
                    if (basicStroke.getLineJoin() == 0 && basicStroke.getDashArray() == null) {
                        double d = basicStroke.getLineWidth();
                        this.drawRectangle(sunGraphics2D, n, n2, n3, n4, d);
                        return;
                    }
                } else {
                    this.drawLine(sunGraphics2D, n, n2, n + n3, n2 + n4);
                    return;
                }
            }
            super.drawRect(sunGraphics2D, n, n2, n3, n4);
        }
    }

    @Override
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            this.fillRectangle(sunGraphics2D, n, n2, n3, n4);
        }
    }

    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState < 3) {
            Line2D line2D;
            BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
            if (shape instanceof Rectangle2D) {
                if (basicStroke.getLineJoin() == 0 && basicStroke.getDashArray() == null) {
                    Rectangle2D rectangle2D = (Rectangle2D)shape;
                    double d = rectangle2D.getWidth();
                    double d2 = rectangle2D.getHeight();
                    double d3 = rectangle2D.getX();
                    double d4 = rectangle2D.getY();
                    if (d >= 0.0 && d2 >= 0.0) {
                        double d5 = basicStroke.getLineWidth();
                        this.drawRectangle(sunGraphics2D, d3, d4, d, d2, d5);
                    }
                    return;
                }
            } else if (shape instanceof Line2D && this.drawGeneralLine(sunGraphics2D, (line2D = (Line2D)shape).getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2())) {
                return;
            }
        }
        this.outpipe.draw(sunGraphics2D, shape);
    }

    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            if (d > 0.0 && d2 > 0.0) {
                double d3 = rectangle2D.getX();
                double d4 = rectangle2D.getY();
                this.fillRectangle(sunGraphics2D, d3, d4, d, d2);
            }
            return;
        }
        this.outpipe.fill(sunGraphics2D, shape);
    }

    static double len(double d, double d2) {
        return d == 0.0 ? Math.abs(d2) : (d2 == 0.0 ? Math.abs(d) : Math.sqrt(d * d + d2 * d2));
    }

    double normalize(double d) {
        return Math.floor(d + this.normRoundingBias) + this.normPosition;
    }

    public boolean drawGeneralLine(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        if (sunGraphics2D.strokeState == 3 || sunGraphics2D.strokeState == 1) {
            return false;
        }
        BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
        int n = basicStroke.getEndCap();
        if (n == 1 || basicStroke.getDashArray() != null) {
            return false;
        }
        double d7 = basicStroke.getLineWidth();
        double d8 = d3 - d;
        double d9 = d4 - d2;
        switch (sunGraphics2D.transformState) {
            case 3: 
            case 4: {
                double[] dArray = new double[]{d, d2, d3, d4};
                sunGraphics2D.transform.transform(dArray, 0, dArray, 0, 2);
                d = dArray[0];
                d2 = dArray[1];
                d3 = dArray[2];
                d4 = dArray[3];
                break;
            }
            case 1: 
            case 2: {
                double d10 = sunGraphics2D.transform.getTranslateX();
                d6 = sunGraphics2D.transform.getTranslateY();
                d += d10;
                d2 += d6;
                d3 += d10;
                d4 += d6;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new InternalError("unknown TRANSFORM state...");
            }
        }
        if (sunGraphics2D.strokeHint != 2) {
            if (sunGraphics2D.strokeState == 0 && this.outrenderer instanceof PixelDrawPipe) {
                int n2 = (int)Math.floor(d - (double)sunGraphics2D.transX);
                int n3 = (int)Math.floor(d2 - (double)sunGraphics2D.transY);
                int n4 = (int)Math.floor(d3 - (double)sunGraphics2D.transX);
                int n5 = (int)Math.floor(d4 - (double)sunGraphics2D.transY);
                ((PixelDrawPipe)((Object)this.outrenderer)).drawLine(sunGraphics2D, n2, n3, n4, n5);
                return true;
            }
            d = this.normalize(d);
            d2 = this.normalize(d2);
            d3 = this.normalize(d3);
            d4 = this.normalize(d4);
        }
        if (sunGraphics2D.transformState >= 3) {
            double d11 = PixelToParallelogramConverter.len(d8, d9);
            if (d11 == 0.0) {
                d11 = 1.0;
                d8 = 1.0;
            }
            double[] dArray = new double[]{d9 / d11, -d8 / d11};
            sunGraphics2D.transform.deltaTransform(dArray, 0, dArray, 0, 1);
            d7 *= PixelToParallelogramConverter.len(dArray[0], dArray[1]);
        }
        d7 = Math.max(d7, this.minPenSize);
        d8 = d3 - d;
        d9 = d4 - d2;
        double d12 = PixelToParallelogramConverter.len(d8, d9);
        if (d12 == 0.0) {
            if (n == 0) {
                return true;
            }
            d6 = d7;
            d5 = 0.0;
        } else {
            d6 = d7 * d8 / d12;
            d5 = d7 * d9 / d12;
        }
        double d13 = d + d5 / 2.0;
        double d14 = d2 - d6 / 2.0;
        if (n == 2) {
            d13 -= d6 / 2.0;
            d14 -= d5 / 2.0;
            d8 += d6;
            d9 += d5;
        }
        this.outrenderer.fillParallelogram(sunGraphics2D, d13, d14, -d5, d6, d8, d9);
        return true;
    }

    public void fillRectangle(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4) {
        AffineTransform affineTransform = sunGraphics2D.transform;
        double d5 = affineTransform.getScaleX();
        double d6 = affineTransform.getShearY();
        double d7 = affineTransform.getShearX();
        double d8 = affineTransform.getScaleY();
        double d9 = d * d5 + d2 * d7 + affineTransform.getTranslateX();
        double d10 = d * d6 + d2 * d8 + affineTransform.getTranslateY();
        d5 *= d3;
        d6 *= d3;
        d7 *= d4;
        d8 *= d4;
        if (this.adjustfill && sunGraphics2D.strokeState < 3 && sunGraphics2D.strokeHint != 2) {
            double d11 = this.normalize(d9);
            double d12 = this.normalize(d10);
            d5 = this.normalize(d9 + d5) - d11;
            d6 = this.normalize(d10 + d6) - d12;
            d7 = this.normalize(d9 + d7) - d11;
            d8 = this.normalize(d10 + d8) - d12;
            d9 = d11;
            d10 = d12;
        }
        this.outrenderer.fillParallelogram(sunGraphics2D, d9, d10, d5, d6, d7, d8);
    }

    public void drawRectangle(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        AffineTransform affineTransform = sunGraphics2D.transform;
        double d8 = affineTransform.getScaleX();
        double d9 = affineTransform.getShearY();
        double d10 = affineTransform.getShearX();
        double d11 = affineTransform.getScaleY();
        double d12 = d * d8 + d2 * d10 + affineTransform.getTranslateX();
        double d13 = d * d9 + d2 * d11 + affineTransform.getTranslateY();
        double d14 = PixelToParallelogramConverter.len(d8, d9) * d5;
        double d15 = PixelToParallelogramConverter.len(d10, d11) * d5;
        d8 *= d3;
        d9 *= d3;
        d10 *= d4;
        d11 *= d4;
        if (sunGraphics2D.strokeState < 3 && sunGraphics2D.strokeHint != 2) {
            d7 = this.normalize(d12);
            d6 = this.normalize(d13);
            d8 = this.normalize(d12 + d8) - d7;
            d9 = this.normalize(d13 + d9) - d6;
            d10 = this.normalize(d12 + d10) - d7;
            d11 = this.normalize(d13 + d11) - d6;
            d12 = d7;
            d13 = d6;
        }
        d14 = Math.max(d14, this.minPenSize);
        d15 = Math.max(d15, this.minPenSize);
        d7 = PixelToParallelogramConverter.len(d8, d9);
        d6 = PixelToParallelogramConverter.len(d10, d11);
        if (d14 >= d7 || d15 >= d6) {
            this.fillOuterParallelogram(sunGraphics2D, d12, d13, d8, d9, d10, d11, d7, d6, d14, d15);
        } else {
            this.outrenderer.drawParallelogram(sunGraphics2D, d12, d13, d8, d9, d10, d11, d14 / d7, d15 / d6);
        }
    }

    public void fillOuterParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d3 / d7;
        double d12 = d4 / d7;
        double d13 = d5 / d8;
        double d14 = d6 / d8;
        if (d7 == 0.0) {
            if (d8 == 0.0) {
                d13 = 0.0;
                d14 = 1.0;
            }
            d11 = d14;
            d12 = -d13;
        } else if (d8 == 0.0) {
            d13 = d12;
            d14 = -d11;
        }
        this.outrenderer.fillParallelogram(sunGraphics2D, d -= ((d11 *= d9) + (d13 *= d10)) / 2.0, d2 -= ((d12 *= d9) + (d14 *= d10)) / 2.0, d3 += d11, d4 += d12, d5 += d13, d6 += d14);
    }
}

