/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.interpreter.Interpreter;
import org.jruby.interpreter.NaiveInterpreterContext;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRMethod
extends DynamicMethod {
    public final IRMethod method;
    private final int temporaryVariableSize;
    boolean displayedCFG = false;

    public InterpretedIRMethod(IRMethod method2, RubyModule implementationClass) {
        super(implementationClass, Visibility.PRIVATE, CallConfiguration.FrameNoneScopeNone);
        this.temporaryVariableSize = method2.getTemporaryVariableSize();
        this.method = method2;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        CFG c;
        NaiveInterpreterContext interp = new NaiveInterpreterContext(context, self, this.method.getLocalVariablesCount(), this.temporaryVariableSize, this.method.getRenamedVariableSize(), args2, block);
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.method.getName() : name2;
            System.out.println("Executing '" + realName + "'");
        }
        if ((c = this.method.getCFG()) == null) {
            this.method.prepareForInterpretation();
            c = this.method.getCFG();
        }
        if (Interpreter.isDebug() && !this.displayedCFG) {
            System.out.println("CFG:\n" + c.getGraph());
            System.out.println("\nInstructions:\n" + c.toStringInstrs());
            this.displayedCFG = true;
        }
        return Interpreter.INTERPRET_METHOD(context, c, interp, name2, this.getImplementationClass(), false);
    }

    public DynamicMethod dup() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

