/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    public abstract Iterator iterator();

    public abstract int size();

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        int n = collection.size();
        while (--n >= 0) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        return this.removeAllInternal(collection);
    }

    boolean removeAllInternal(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        return this.retainAllInternal(collection);
    }

    boolean retainAllInternal(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object[] toArray() {
        Iterator iterator = this.iterator();
        int n = this.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        } else if (objectArray.length > n) {
            objectArray[n] = null;
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    public String toString() {
        Iterator iterator = this.iterator();
        StringBuffer stringBuffer = new StringBuffer("[");
        boolean bl = iterator.hasNext();
        while (bl) {
            Object object = iterator.next();
            if (object == this) {
                stringBuffer.append("<this>");
            } else {
                stringBuffer.append(object);
            }
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static final boolean equals(Object object, Object object2) {
        boolean bl;
        if (object == null) {
            bl = false;
            if (object2 == null) {
                bl = true;
            }
        } else {
            bl = object.equals(object2);
        }
        return bl;
    }

    static final int hashCode(Object object) {
        int n = 0;
        if (object != null) {
            n = object.hashCode();
        }
        return n;
    }

    protected AbstractCollection() {
    }
}

