/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.text.BreakIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;

public class Utilities {
    private static final int BUF_LENGTH = 64;

    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        char[] cArray = segment.array;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getAscent();
        int n5 = n;
        int n6 = n2 - n4;
        int n7 = 0;
        int n8 = segment.offset;
        int n9 = 0;
        int n10 = segment.offset + segment.count;
        int n11 = segment.offset;
        while (n11 < n10) {
            char c = cArray[n11];
            if (c == '\t' || c == '\n') {
                if (n9 > 0) {
                    graphics.drawChars(cArray, n8, n9, n5, n6 + n4);
                    n5 += n7;
                    n7 = 0;
                }
                n8 = n11 + 1;
                n9 = 0;
            }
            switch (c) {
                case '\t': {
                    if (tabExpander != null) {
                        n5 = (int)tabExpander.nextTabStop(n5, n3 + n11 - segment.offset);
                        break;
                    }
                    n5 += fontMetrics.charWidth(' ');
                    break;
                }
                case '\n': {
                    n6 += fontMetrics.getHeight();
                    n5 = n;
                    break;
                }
                default: {
                    ++n9;
                    n7 += fontMetrics.charWidth(cArray[n11]);
                }
            }
            ++n11;
        }
        if (n9 > 0) {
            graphics.drawChars(cArray, n8, n9, n5, n6 + n4);
        }
        return n5 + n7;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        char[] cArray = segment.array;
        int n3 = n;
        int n4 = 0;
        int n5 = segment.offset;
        while (n5 < segment.offset + segment.count) {
            switch (cArray[n5]) {
                case '\t': {
                    if (tabExpander != null) {
                        n3 = (int)tabExpander.nextTabStop(n3, n2 + n5 - segment.offset);
                        break;
                    }
                    n3 += fontMetrics.charWidth(' ');
                    break;
                }
                case '\n': {
                    n4 = Math.max(n4, (n3 += fontMetrics.charWidth(cArray[n5])) - n);
                    n3 = n;
                    break;
                }
                default: {
                    n3 += fontMetrics.charWidth(cArray[n5]);
                }
            }
            ++n5;
        }
        n4 = Math.max(n4, n3 - n);
        return n4;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, boolean bl) {
        int n4 = n;
        int n5 = 0;
        while (n5 < segment.count) {
            char c = segment.array[segment.offset + n5];
            if (c == '\u0000') {
                if (bl) break;
                --n5;
                break;
            }
            n4 = c != '\t' ? (n4 += fontMetrics.charWidth(c)) : (tabExpander == null ? (n4 += fontMetrics.charWidth(' ')) : (int)tabExpander.nextTabStop(n4, n5));
            if (n4 > n2) {
                if (bl) break;
                --n5;
                break;
            }
            ++n5;
        }
        return n5 + n3;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, true);
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n > jTextComponent.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        int n3 = breakIterator.next();
        while (n3 != -1) {
            int n4 = n2;
            while (n4 < n3) {
                if (Character.isLetter(string.charAt(n4))) {
                    return n2;
                }
                ++n4;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n > jTextComponent.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        int n3 = breakIterator.previous();
        while (n3 != -1) {
            int n4 = n2;
            while (n4 < n) {
                if (Character.isLetter(string.charAt(n4))) {
                    return n2;
                }
                ++n4;
            }
            n2 = n3;
            n3 = breakIterator.previous();
        }
        return 0;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n >= jTextComponent.getText().length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        if (breakIterator.isBoundary(n)) {
            return n;
        }
        return breakIterator.preceding(n);
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n >= jTextComponent.getText().length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        return breakIterator.following(n);
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (string == null) {
            return -1;
        }
        int n2 = n + (string.length() - 1 - n) / 2;
        int n3 = n;
        int n4 = string.length() + 1;
        while (true) {
            if (jTextComponent.modelToView((int)n2).y != jTextComponent.modelToView((int)n).y) {
                n4 = n2;
                if (n4 != (n2 = n3 + (n2 + 1 - n3) / 2)) continue;
                return n2 - 1;
            }
            n3 = n2;
            if (n3 == (n2 += (n4 - n2) / 2)) break;
        }
        return n3;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (string == null) {
            return -1;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (jTextComponent.modelToView((int)n3).y != jTextComponent.modelToView((int)n).y) {
                n4 = n3;
                if (n4 != (n3 = n2 - (n2 + 1 - n3) / 2)) continue;
                return n3 + 1;
            }
            if ((n3 -= (n3 - n4) / 2) == (n2 = n3)) break;
        }
        return n3;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        int n4 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(segment);
        if (n4 >= segment.count) {
            return n4;
        }
        int n5 = breakIterator.preceding(n4 + 1);
        if (n5 != 0) {
            return n5;
        }
        return n4;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        Element element = null;
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            element = styledDocument.getParagraphElement(n);
        } else {
            Element element2 = jTextComponent.getDocument().getDefaultRootElement();
            int n2 = element2.getElementIndex(n);
            element = element2.getElement(n2);
        }
        return element;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowStart(jTextComponent, n);
        if (n3 == -1) {
            return -1;
        }
        Point point = jTextComponent.modelToView(n3 - 1).getLocation();
        point.x = n2;
        n3 = jTextComponent.viewToModel(point);
        int n4 = jTextComponent.modelToView((int)n3).getLocation().x;
        int n5 = jTextComponent.modelToView((int)(n3 + 1)).getLocation().x;
        if (Math.abs(n4 - n2) <= Math.abs(n5 - n2)) {
            return n3;
        }
        return n3 + 1;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowEnd(jTextComponent, n);
        if (n3 == -1) {
            return -1;
        }
        Point point = jTextComponent.modelToView(n3 + 1).getLocation();
        point.x = n2;
        n3 = jTextComponent.viewToModel(point);
        if (n3 == jTextComponent.getDocument().getLength()) {
            return n3;
        }
        int n4 = jTextComponent.modelToView((int)n3).getLocation().x;
        int n5 = jTextComponent.modelToView((int)(n3 + 1)).getLocation().x;
        if (Math.abs(n4 - n2) <= Math.abs(n5 - n2)) {
            return n3;
        }
        return n3 + 1;
    }
}

