/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Panel.h
 *  MakeHuman Project <info@makehuman.org>
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef PANEL_H
#define PANEL_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <list>
#include <cassert>
#include <animorph/Color.h>
#include "Window.h"

using std::list;
using std::string;
using Animorph::Color;

namespace mhgui {

class Widget;

class Panel : public Component
{
protected:
  list <Widget*> widgetList;
  int            widgetListChangedCount;

  bool rightAnchor;
  bool bottomAnchor;
  Window  *parentWindow;

public:
  Panel (uint32_t    inPanelId,
         const Rect& inGeometry);
  virtual ~Panel ();

  enum Alignment
  {
    HORIZONTAL,
    VERTICAL,
    FREE
  };

  virtual void show ();
  virtual void hide ();
  virtual void draw ();

  bool addWidget             (Widget *w);
  void removeWidget          (Widget *w);

  bool isMouseOverWidgets    (const Point& inMousePos);
  bool isMouseClickWidgets   (const Point& inMousePos, int button, int state);
  bool isMouseDraggedWidgets (const Point& inMousePos);
  bool isKeyTypeWidgets      (unsigned char key);

  void show_all              ();

  void setBottomAnchor (bool anchor) {bottomAnchor = anchor;}
  bool getBottomAnchor () {return bottomAnchor;}

  void setRightAnchor (bool anchor) {rightAnchor = anchor;}
  bool getRightAnchor () {return rightAnchor;}

  void setAlignment (Alignment align) {this->align = align;}
  Alignment getAlignment () {return align;}

  void setBackgroundColor (const Color& c) {backColor = c;}
  const Color& getBackgroundColor () {return backColor;}

  // TODO: maximize couldn't been unset!
  void setMaximize (bool maximize) {this->maximize = maximize;}
  bool getMaximize () {return maximize;}

  void setRowSpacing (int space) {rowSpacing = space;}
  int getRowSpacing () {return rowSpacing;}

  void setColumnSpacing (int space) {columnSpacing = space;}
  int getColumnSpacing () {return columnSpacing;}

  virtual void calcWidgetPosition ();

  // this is not really needed, as there's only one top-level-window,
  // but it's easier to access this way...
  const Window* getParentWindow() const;
  void          setParentWindow(Window* w);

private: // intentionally not implemeted
  Panel(const Panel&);
  Panel& operator=(const Panel&);

  Color backColor;
  bool maximize;
  Alignment align;
  int rowSpacing;
  int columnSpacing;

public:
  typedef list<Widget*>::iterator WidgetIterator;

  WidgetIterator begin() {return widgetList.begin();}
  WidgetIterator end()   {return widgetList.end();}
};

} // namespace mhgui

#endif //PANEL_H
