/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.attributes.JLineNumberTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ResourceBundle;

public class JCodeAttr
extends JAttribute {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    private int max_stack;
    private int max_locals;
    private JInstruction code = null;
    private JExceptionRecord[] exceptions = null;
    private JLineNumberTableAttr linenumber_table_att = null;
    private JLocalVarTableAttr local_vars_table_att = null;
    private JAttribute[] attributes;

    JCodeAttr(JConstantPool jConstantPool) {
        super(jConstantPool);
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public JInstruction getCode() {
        return this.code;
    }

    public JExceptionRecord[] getExceptions() {
        return this.exceptions;
    }

    public JLineNumberTableAttr getLineNumberTableAttr() {
        return this.linenumber_table_att;
    }

    public JLocalVarTableAttr getLocalVarTableAttr() {
        return this.local_vars_table_att;
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    public void resolve() {
        JInstruction jInstruction;
        for (jInstruction = this.code; jInstruction != null; jInstruction = jInstruction.getNextInstr()) {
            jInstruction.resolve();
        }
        for (JExceptionRecord object : this.exceptions) {
            object.resolve();
        }
        for (JAttribute jAttribute : this.attributes) {
            if (jAttribute instanceof JLineNumberTableAttr) {
                if (null != this.linenumber_table_att) {
                    throw new ClassFormatError(messages.getString("attr.1"));
                }
                this.linenumber_table_att = (JLineNumberTableAttr)jAttribute;
            }
            if (jAttribute instanceof JLocalVarTableAttr) {
                if (null != this.local_vars_table_att) {
                    throw new ClassFormatError(messages.getString("attr.2"));
                }
                this.local_vars_table_att = (JLocalVarTableAttr)jAttribute;
            }
            jAttribute.resolve();
        }
        if (this.linenumber_table_att != null) {
            for (jInstruction = this.code; jInstruction != null; jInstruction = jInstruction.getNextInstr()) {
                int n = this.linenumber_table_att.getLineNumber(jInstruction.getPC());
                jInstruction.setSournceLineNumber(n);
            }
        }
    }

    @Override
    public void parse(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        JInstruction jInstruction;
        int n4 = dataInputStream.readInt();
        this.max_stack = dataInputStream.readUnsignedShort();
        this.max_locals = dataInputStream.readUnsignedShort();
        int n5 = dataInputStream.readInt();
        JInstruction jInstruction2 = this.code;
        for (n3 = 0; n3 < n5; n3 += jInstruction.getSizeInBytes()) {
            n2 = dataInputStream.readUnsignedByte();
            jInstruction = JInstruction.create(this.cp, n3, n2);
            jInstruction.parse(dataInputStream);
            if (this.code == null) {
                this.code = jInstruction;
                jInstruction2 = jInstruction;
                continue;
            }
            jInstruction2.setNextInstr(jInstruction);
            jInstruction.setPrevInstr(jInstruction2);
            jInstruction2 = jInstruction;
        }
        n3 = dataInputStream.readUnsignedShort();
        this.exceptions = new JExceptionRecord[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = dataInputStream.readUnsignedShort();
            n = dataInputStream.readUnsignedShort();
            int n7 = dataInputStream.readUnsignedShort();
            int n8 = dataInputStream.readUnsignedShort();
            this.exceptions[n2] = new JExceptionRecord(n6, n, n7, n8, this.cp);
        }
        n2 = dataInputStream.readUnsignedShort();
        this.attributes = new JAttribute[n2];
        for (int i = 0; i < n2; ++i) {
            n = dataInputStream.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.cp, n);
            this.attributes[i].parse(dataInputStream);
        }
    }
}

