/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.I2SException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrArrayConverter
extends InstructionConverter {
    public InstrArrayConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    @Override
    public JcInstruction convert() throws Exception {
        int n = this.java_instr.getOpcode();
        switch (n) {
            case 188: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                if (operandStackEntry.getType() == 3 && !operandStackEntry.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry);
                int n2 = ((JInstrByteIndex)this.java_instr).getIndex();
                if (n2 == 10) {
                    String string = this.method_converter.getClassName();
                    if (this.method_converter.getPackageConverter().isIntSupported()) {
                        Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.4", string.replace('/', '.'));
                        this.method_converter.getPackageConverter().setIntFlag(true);
                    } else {
                        Notifier.error(this.java_instr.getSourceLineNumber(), "int.4", string.replace('/', '.'));
                        throw new ConversionException();
                    }
                }
                int n3 = this.getAtype(n2);
                this.jc_instr = new JcInstrByteIndex(144, n3);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 189: {
                String string;
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                if (operandStackEntry.getType() == 3 && !operandStackEntry.isTypeKnown()) {
                    string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry);
                string = ((JInstrClassRef)this.java_instr).getClassName();
                JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
                JcConstantClassRef jcConstantClassRef = jcConstantPool.addConstantClassRef(string);
                this.jc_instr = new JcInstrClassRef(145, jcConstantClassRef);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 51: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry.getType() == 3 && !operandStackEntry.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(37);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 53: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry.getType() == 3 && !operandStackEntry.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(38);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
            case 50: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry.getType() == 3 && !operandStackEntry.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(36);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 46: {
                String string;
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry.getType() == 3 && !operandStackEntry.isTypeKnown()) {
                    string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry);
                string = this.method_converter.getClassName();
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", string.replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.5", string.replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                this.jc_instr = new JcInstrNoOperands(39);
                this.operand_stack.push(3, this.instr_container);
                return this.jc_instr;
            }
            case 84: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                int n4 = operandStackEntry.getSizeInWords();
                OperandStackEntry operandStackEntry2 = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry2.getType() == 3 && !operandStackEntry2.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry2.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry2);
                this.jc_instr = new JcInstrNoOperands(56);
                if (n4 == 2) {
                    throw new I2SException(this.jc_instr);
                }
                return this.jc_instr;
            }
            case 86: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                int n5 = operandStackEntry.getSizeInWords();
                OperandStackEntry operandStackEntry3 = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry3.getType() == 3 && !operandStackEntry3.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry3.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry3);
                this.jc_instr = new JcInstrNoOperands(57);
                if (n5 == 2) {
                    throw new I2SException(this.jc_instr);
                }
                return this.jc_instr;
            }
            case 83: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                OperandStackEntry operandStackEntry4 = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry4.getType() == 3 && !operandStackEntry4.isTypeKnown()) {
                    String string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry4.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry4);
                this.jc_instr = new JcInstrNoOperands(55);
                return this.jc_instr;
            }
            case 79: {
                String string;
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                OperandStackEntry operandStackEntry5 = this.operand_stack.pop();
                this.operand_stack.pop();
                if (operandStackEntry5.getType() == 3 && !operandStackEntry5.isTypeKnown()) {
                    string = this.method_converter.getClassName();
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "int.22", string.replace('/', '.'));
                    operandStackEntry5.rollBack(true);
                }
                this.checkArrayCountOrIndexType(operandStackEntry5);
                string = this.method_converter.getClassName();
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", string.replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.5", string.replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (operandStackEntry.getType() != 3) {
                    operandStackEntry.rollBack();
                }
                this.jc_instr = new JcInstrNoOperands(58);
                return this.jc_instr;
            }
            case 190: {
                this.operand_stack.pop();
                this.jc_instr = new JcInstrNoOperands(146);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private void checkArrayCountOrIndexType(OperandStackEntry operandStackEntry) throws Exception {
        String string = this.method_converter.getClassName();
        if (operandStackEntry.getType() == 3) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.20", string.replace('/', '.'));
            throw new ConversionException();
        }
        if (operandStackEntry.hasOverflowPotential()) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.20", string.replace('/', '.'));
            throw new ConversionException();
        }
    }

    private int getAtype(int n) throws Exception {
        switch (n) {
            case 4: {
                return 10;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return 13;
            }
        }
        throw new ConversionException();
    }
}

