/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;

public class RemotePackExporter {
    private static final Map<String, String> scriptMapper = new HashMap<String, String>(){
        {
            this.put(IntegrationUtils.PLATFORM_LINUX_AMD64_OS, "linuxamd64");
            this.put(IntegrationUtils.PLATFORM_LINUX_OS, "linux");
            this.put(IntegrationUtils.PLATFORM_MAC_OS, "mac");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS, "solamd64");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS, "solx86");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS, "solsparc");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS, "solsparcv9");
            this.put(IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS, "winamd64");
            this.put(IntegrationUtils.PLATFORM_WINDOWS_OS, "win");
        }
    };
    private static final Map<String, String> jdkMapper = new HashMap<String, String>(){
        {
            this.put(TargetPlatformEnum.JDK5.toString(), "15");
            this.put(TargetPlatformEnum.JDK6.toString(), "15");
            this.put(TargetPlatformEnum.JDK7.toString(), "15");
            this.put(TargetPlatformEnum.JDK_CVM.toString(), "cvm");
        }
    };
    private AntProjectCookie cookie;

    public static final RemotePackExporter getInstance() {
        return Singleton.INSTANCE;
    }

    private RemotePackExporter() throws ExceptionInInitializerError {
        try {
            File antFile = InstalledFileLocator.getDefault().locate("remote-pack-defs/build.xml", "org-netbeans-lib-profiler", false);
            this.cookie = (AntProjectCookie)DataObject.find((FileObject)FileUtil.toFileObject((File)antFile)).getCookie(AntProjectCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(String exportPath, String hostOS, String jvm) throws IOException {
        String packPath = this.getRemotePackPath(exportPath, hostOS);
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)("Generating Remote Pack to " + packPath));
        ph.setInitialDelay(500);
        ph.start();
        try {
            AntTargetExecutor.Env env = new AntTargetExecutor.Env();
            env.setVerbosity(3);
            Properties antProperties = new Properties();
            antProperties.setProperty("lib.dir", "../lib");
            antProperties.setProperty("dest.dir", exportPath != null ? exportPath : System.getProperty("java.io.tmpdir"));
            env.setProperties(antProperties);
            AntTargetExecutor ate = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env);
            ate.execute(this.cookie, new String[]{"profiler-server-" + scriptMapper.get(hostOS) + "-" + jdkMapper.get(jvm)}).result();
        }
        finally {
            ph.finish();
        }
        return packPath;
    }

    public String getRemotePackPath(String exportPath, String hostOS) {
        return exportPath + File.separator + "profiler-server-" + scriptMapper.get(hostOS) + ".zip";
    }

    public void export(String hostOS, String jvm) throws IOException {
        this.export(null, hostOS, jvm);
    }

    private static final class Singleton {
        private static final RemotePackExporter INSTANCE = new RemotePackExporter();

        private Singleton() {
        }
    }
}

