/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ArrayNode
extends ListNode
implements ILiteralNode {
    private boolean lightweight = false;

    public ArrayNode(ISourcePosition position, Node firstNode) {
        super(position, NodeType.ARRAYNODE, firstNode);
        assert (firstNode != null) : "ArrayNode.first == null";
    }

    public ArrayNode(ISourcePosition position) {
        super(position, NodeType.ARRAYNODE);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitArrayNode(this);
    }

    public void setLightweight(boolean lightweight) {
        this.lightweight = lightweight;
    }

    public boolean isLightweight() {
        return this.lightweight;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject[] array = this.interpretPrimitive(runtime, context, self, aBlock);
        return this.lightweight ? runtime.newArrayNoCopyLight(array) : runtime.newArrayNoCopy(array);
    }

    public IRubyObject[] interpretPrimitive(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        int size = this.size();
        IRubyObject[] array = new IRubyObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i).interpret(runtime, context, self, aBlock);
        }
        return array;
    }
}

