/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class FlipNode
extends Node {
    private final Node beginNode;
    private final Node endNode;
    private final boolean exclusive;
    private final int location;

    public FlipNode(ISourcePosition position, Node beginNode, Node endNode, boolean exclusive, int location) {
        super(position, NodeType.FLIPNODE);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive;
        this.location = location;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFlipNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        DynamicScope scope = context.getCurrentScope();
        IRubyObject nil = runtime.getNil();
        int index = this.getIndex();
        DynamicScope flipScope = scope.getFlipScope();
        flipScope.growIfNeeded();
        IRubyObject result = flipScope.getValueDepthZeroOrNil(index, nil);
        if (this.exclusive) {
            if (result == null || !result.isTrue()) {
                result = this.beginNode.interpret(runtime, context, self, aBlock).isTrue() ? runtime.getTrue() : runtime.getFalse();
                flipScope.setValueDepthZero(result, index);
                return result;
            }
            if (this.endNode.interpret(runtime, context, self, aBlock).isTrue()) {
                flipScope.setValueDepthZero(runtime.getFalse(), index);
            }
            return runtime.getTrue();
        }
        if (result == null || !result.isTrue()) {
            if (this.beginNode.interpret(runtime, context, self, aBlock).isTrue()) {
                flipScope.setValueDepthZero(this.endNode.interpret(runtime, context, self, aBlock).isTrue() ? runtime.getFalse() : runtime.getTrue(), index);
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        if (this.endNode.interpret(runtime, context, self, aBlock).isTrue()) {
            flipScope.setValueDepthZero(runtime.getFalse(), index);
        }
        return runtime.getTrue();
    }
}

