/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyThread;
import org.jruby.nb.RubyThreadGroup;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.exceptions.ThreadKill;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Frame currentFrame;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] args, Block currentBlock) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext tc = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.currentFrame = tc.getCurrentFrame();
        this.arguments = args;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldContextClassLoader;
        ThreadContext context;
        block46: {
            this.javaThread = Thread.currentThread();
            context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
            oldContextClassLoader = null;
            try {
                oldContextClassLoader = this.javaThread.getContextClassLoader();
                this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block46;
                System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
            }
        }
        context.preRunThread(this.currentFrame);
        try {
            IRubyObject result = this.proc.call(context, this.arguments);
            this.rubyThread.cleanTerminate(result);
        }
        catch (ThreadKill tk) {
            Object object = this.rubyThread.killLock;
            synchronized (object) {
                this.rubyThread.killLock.notifyAll();
            }
        }
        catch (JumpException.ReturnJump rj) {
            this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
        }
        catch (RaiseException e) {
            this.rubyThread.exceptionRaised(e);
        }
        catch (MainExitException mee) {
            this.runtime.getThreadService().getMainThread().kill();
        }
        finally {
            block48: {
                this.runtime.getThreadService().setCritical(false);
                this.runtime.getThreadService().unregisterThread(this.rubyThread);
                RubyThread tk = this.rubyThread;
                synchronized (tk) {
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                }
                try {
                    this.javaThread.setContextClassLoader(oldContextClassLoader);
                }
                catch (SecurityException se) {
                    if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block48;
                    System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                }
            }
        }
    }
}

