/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaArray;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"JavaArrayUtilities"})
public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(Ruby runtime) {
        RubyModule javaArrayUtils = runtime.defineModule("JavaArrayUtilities");
        javaArrayUtils.defineAnnotatedMethods(JavaArrayUtilities.class);
        return javaArrayUtils;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(IRubyObject recv, IRubyObject wrappedObject) {
        Ruby runtime = recv.getRuntime();
        JavaObject byteArray = (JavaObject)wrappedObject.dataGetStruct();
        if (!(byteArray instanceof JavaArray) || !(((JavaArray)byteArray).getValue() instanceof byte[])) {
            throw runtime.newTypeError("wrong argument type " + wrappedObject.getMetaClass() + " (expected byte[])");
        }
        return runtime.newString(new ByteList((byte[])((JavaArray)byteArray).getValue(), true));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_string_to_bytes(IRubyObject recv, IRubyObject string) {
        Ruby runtime = recv.getRuntime();
        if (!(string instanceof RubyString)) {
            throw runtime.newTypeError(string, runtime.getString());
        }
        return Java.java_to_ruby(recv, JavaObject.wrap(runtime, ((RubyString)string).getBytes()), Block.NULL_BLOCK);
    }
}

