/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class Block {
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    private boolean[] escaped = new boolean[]{false};
    public static final Block NULL_BLOCK = new Block(){

        @Override
        public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
            throw context.getRuntime().newLocalJumpError("noreason", value, "yield called out of block");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args) {
            throw context.getRuntime().newLocalJumpError("noreason", context.getRuntime().newArrayNoCopy(args), "yield called out of block");
        }

        @Override
        public IRubyObject yield(ThreadContext context, IRubyObject value) {
            throw context.getRuntime().newLocalJumpError("noreason", value, "yield called out of block");
        }

        @Override
        public Block cloneBlock() {
            return this;
        }

        @Override
        public BlockBody getBody() {
            return BlockBody.NULL_BODY;
        }
    };

    protected Block() {
        this(null, null);
    }

    public Block(BlockBody body, Binding binding) {
        this.body = body;
        this.binding = binding;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.body.call(context, args, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.body.yield(context, value, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        return this.body.yield(context, value, self, klass, aValue, this.binding, this.type);
    }

    public Block cloneBlock() {
        Block newBlock = this.body.cloneBlock(this.binding);
        newBlock.type = this.type;
        newBlock.escaped = this.escaped;
        return newBlock;
    }

    public Arity arity() {
        return this.body.arity();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public final boolean isGiven() {
        return this != NULL_BLOCK;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    public boolean isEscaped() {
        return this.escaped[0];
    }

    public void escape() {
        this.escaped[0] = true;
    }

    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA,
        THREAD;

    }
}

