/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.hints.analyzer.ui.AnalyzerTopComponent;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class NextError
extends AbstractAction
implements PropertyChangeListener {
    private AnalyzerTopComponent comp;

    public NextError(AnalyzerTopComponent analyzerTopComponent) {
        this.comp = analyzerTopComponent;
        this.comp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public boolean isEnabled() {
        boolean bl;
        Node node = this.getNextMeaningfullNode();
        boolean bl2 = bl = node != null;
        if (node != null) {
            this.comp.nodesForNext.add(0, node);
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Node node = this.getNextMeaningfullNode();
        if (node == null) {
            this.fireEnabledChanged();
            return;
        }
        FixDescription fixDescription = (FixDescription)node.getLookup().lookup(FixDescription.class);
        assert (fixDescription != null);
        this.addToSeenNodes(node);
        try {
            this.comp.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
        if (this.comp.fixOnNext() && !fixDescription.isFixed()) {
            try {
                fixDescription.implement();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        ErrorDescription errorDescription = fixDescription.getErrors();
        UiUtils.open((FileObject)errorDescription.getFile(), (int)errorDescription.getRange().getBegin().getOffset());
        this.fireEnabledChanged();
    }

    private Node getNextMeaningfullNode() {
        if (this.comp.nodesForNext == null) {
            this.comp.nodesForNext = new LinkedList<Node>();
            this.comp.nodesForNext.add(this.comp.getExplorerManager().getRootContext());
        }
        List<Node> list = this.comp.nodesForNext;
        while (!list.isEmpty()) {
            Node node = list.remove(0);
            if (node.getChildren() != FilterNode.Children.LEAF) {
                list.addAll(0, Arrays.asList(node.getChildren().getNodes(true)));
                continue;
            }
            FixDescription fixDescription = (FixDescription)node.getLookup().lookup(FixDescription.class);
            if (fixDescription == null) continue;
            Node[] nodeArray = this.comp.getExplorerManager().getSelectedNodes();
            if (nodeArray.length == 1 && nodeArray[0] == node) {
                this.addToSeenNodes(node);
                continue;
            }
            if (this.comp.goOverFixed() && !fixDescription.isFixed()) {
                this.addToSeenNodes(node);
                continue;
            }
            return node;
        }
        return null;
    }

    private void addToSeenNodes(Node node) {
        if (this.comp.seenNodes == null) {
            this.comp.seenNodes = new LinkedList<Node>();
        }
        this.comp.seenNodes.add(0, node);
    }

    void fireEnabledChanged() {
        this.firePropertyChange("enabled", null, this.isEnabled());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireEnabledChanged();
    }
}

