/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.openide.util.Lookup;

public abstract class CsmFileInfoQuery {
    private static final CsmFileInfoQuery EMPTY = new Empty();
    private static CsmFileInfoQuery defaultResolver;

    protected CsmFileInfoQuery() {
    }

    public static CsmFileInfoQuery getDefault() {
        if (defaultResolver != null) {
            return defaultResolver;
        }
        defaultResolver = (CsmFileInfoQuery)Lookup.getDefault().lookup(CsmFileInfoQuery.class);
        return defaultResolver == null ? EMPTY : defaultResolver;
    }

    public abstract List<String> getSystemIncludePaths(CsmFile var1);

    public abstract List<String> getUserIncludePaths(CsmFile var1);

    public abstract List<CsmOffsetable> getUnusedCodeBlocks(CsmFile var1);

    public abstract List<CsmReference> getMacroUsages(CsmFile var1);

    public abstract CsmOffsetable getGuardOffset(CsmFile var1);

    public abstract NativeFileItem getNativeFileItem(CsmFile var1);

    public abstract List<CsmInclude> getIncludeStack(CsmFile var1);

    public abstract Collection<CsmCompilationUnit> getCompilationUnits(CsmFile var1, int var2);

    public abstract Collection<CsmInclude> getBrokenIncludes(CsmFile var1);

    public abstract boolean hasBrokenIncludes(CsmFile var1);

    public abstract long getFileVersion(CsmFile var1);

    private static final class Empty
    extends CsmFileInfoQuery {
        Empty() {
        }

        @Override
        public List<String> getSystemIncludePaths(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public List<String> getUserIncludePaths(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public List<CsmReference> getMacroUsages(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public CsmOffsetable getGuardOffset(CsmFile file) {
            return null;
        }

        @Override
        public NativeFileItem getNativeFileItem(CsmFile file) {
            return null;
        }

        @Override
        public List<CsmInclude> getIncludeStack(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public long getFileVersion(CsmFile file) {
            return 0L;
        }

        @Override
        public Collection<CsmInclude> getBrokenIncludes(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public boolean hasBrokenIncludes(CsmFile file) {
            return false;
        }

        @Override
        public Collection<CsmCompilationUnit> getCompilationUnits(CsmFile file, int offset) {
            return Collections.singleton(CsmCompilationUnit.createCompilationUnit(file));
        }
    }
}

