/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ide;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;

public class DebugSupport {
    private static final String JSP_SERVLET_NAME = "jsp";
    private static final String JSP_SERVLET_CLASS = "org.apache.jasper.servlet.JspServlet";
    private static final String MAPPED_PARAM_NAME = "mappedfile";
    private static final String MAPPED_PARAM_VALUE = "true";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allowDebugging(TomcatManager tomcatManager) throws IOException, SAXException {
        String string = tomcatManager.getUri();
        File file = DebugSupport.getDefaultWebXML(tomcatManager);
        if (file == null) {
            Logger.getLogger(DebugSupport.class.getName()).log(Level.INFO, null, new Exception(string));
            return;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(file);
        if (webApp == null) {
            Logger.getLogger(DebugSupport.class.getName()).log(Level.INFO, null, new Exception(string));
            return;
        }
        boolean bl = DebugSupport.setMappedProperty(webApp);
        if (bl) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                webApp.write((OutputStream)fileOutputStream);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    private static File getDefaultWebXML(TomcatManager tomcatManager) {
        File file = tomcatManager.getTomcatProperties().getCatalinaDir();
        File file2 = new File(file, "conf" + File.separator + "web.xml");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static boolean setMappedProperty(WebApp webApp) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        Servlet[] servletArray = webApp.getServlet();
        for (n = 0; n < servletArray.length; ++n) {
            if (!servletArray[n].getServletName().equals(JSP_SERVLET_NAME) || !servletArray[n].getServletClass().equals(JSP_SERVLET_CLASS)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            try {
                Servlet servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName(JSP_SERVLET_NAME);
                servlet.setServletClass(JSP_SERVLET_CLASS);
                InitParam initParam = (InitParam)servlet.createBean("InitParam");
                initParam.setParamName(MAPPED_PARAM_NAME);
                initParam.setParamValue(MAPPED_PARAM_VALUE);
                servlet.addInitParam(initParam);
                webApp.addServlet(servlet);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        } else {
            try {
                int n2;
                boolean bl3 = false;
                InitParam[] initParamArray = servletArray[n].getInitParam();
                for (n2 = 0; n2 < initParamArray.length; ++n2) {
                    if (!initParamArray[n2].getParamName().equals(MAPPED_PARAM_NAME)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    if (!initParamArray[n2].getParamValue().equals(MAPPED_PARAM_VALUE)) {
                        initParamArray[n2].setParamValue(MAPPED_PARAM_VALUE);
                        bl = true;
                    }
                } else {
                    InitParam initParam = (InitParam)servletArray[n].createBean("InitParam");
                    initParam.setParamName(MAPPED_PARAM_NAME);
                    initParam.setParamValue(MAPPED_PARAM_VALUE);
                    servletArray[n].addInitParam(initParam);
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        return bl;
    }
}

