/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.gsf.api.EditorOptions;
import org.netbeans.modules.gsf.api.EditorOptionsFactory;

public class GsfEditorOptionsFactory
implements EditorOptionsFactory {
    public EditorOptions get(String mimeType) {
        return new GsfEditorOptions(mimeType);
    }

    private final class GsfEditorOptions
    extends EditorOptions {
        private final String mimeType;
        private final Preferences prefs;

        GsfEditorOptions(String mimeType) {
            this.mimeType = mimeType;
            this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        }

        public int getTabSize() {
            return this.prefs.getInt("tab-size", 8);
        }

        public boolean getExpandTabs() {
            return this.prefs.getBoolean("expand-tabs", true);
        }

        public int getSpacesPerTab() {
            return this.prefs.getInt("spaces-per-tab", 2);
        }

        public boolean getMatchBrackets() {
            return this.prefs.getBoolean("pair-characters-completion", true);
        }

        public int getRightMargin() {
            return this.prefs.getInt("text-limit-width", 80);
        }
    }
}

