/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.support.CaretAwareSourceTaskFactory;
import org.netbeans.napi.gsfret.source.support.SelectionAwareSourceTaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class SuggestionsTask
extends ScanningCancellableTask<CompilationInfo> {
    static Language getHintsProviderLanguage(Document doc, int offset) {
        BaseDocument baseDoc = (BaseDocument)doc;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDoc, offset);
        for (Language l : list) {
            if (l.getHintsProvider() == null) continue;
            return l;
        }
        return null;
    }

    @Override
    public void run(CompilationInfo info) throws Exception {
        this.resume();
        Document doc = info.getDocument();
        if (doc == null) {
            return;
        }
        int[] range = SelectionAwareSourceTaskFactory.getLastSelection(info.getFileObject());
        if (range != null && range.length == 2 && range[0] != -1 && range[1] != -1 && range[0] != range[1]) {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)SuggestionsTask.class.getName(), Collections.emptyList());
            return;
        }
        int pos = CaretAwareSourceTaskFactory.getLastPosition(info.getFileObject());
        if (pos == -1) {
            return;
        }
        Language language = SuggestionsTask.getHintsProviderLanguage(doc, pos);
        if (language == null) {
            return;
        }
        HintsProvider provider = language.getHintsProvider();
        assert (provider != null);
        GsfHintsManager manager = language.getHintsManager();
        if (manager == null) {
            return;
        }
        RuleContext ruleContext = manager.createRuleContext(info, language, pos, -1, -1);
        if (ruleContext == null) {
            return;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        ArrayList hints = new ArrayList();
        provider.computeSuggestions((HintsProvider.HintsManager)manager, ruleContext, hints, pos);
        for (Hint hint : hints) {
            ErrorDescription desc = manager.createDescription(hint, ruleContext, false);
            result.add(desc);
        }
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)SuggestionsTask.class.getName(), result);
    }
}

