/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.metamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class ModelUnit {
    private final ClassPath bootPath;
    private final ClassPath compilePath;
    private final ClassPath sourcePath;
    private final WebModule module;
    private final PropertyChangeSupport changeSupport;
    private List<FileObject> configFiles;
    private List<FileObject> configRoots = new LinkedList<FileObject>();
    private static final String META_INF = "META-INF";
    private static final String FACES_CONFIG = "faces-config.xml";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String DEFAULT_FACES_CONFIG_PATH = "WEB-INF/faces-config.xml";
    public final String PROP_CONFIG_FILES = "configFiles";

    public static ModelUnit create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, WebModule webModule) {
        return new ModelUnit(classPath, classPath2, classPath3, webModule);
    }

    private ModelUnit(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, WebModule webModule) {
        Parameters.notNull((CharSequence)"sourcePath", (Object)classPath3);
        this.bootPath = classPath;
        this.compilePath = classPath2;
        this.sourcePath = classPath3;
        this.module = webModule;
        this.changeSupport = new PropertyChangeSupport(this);
        this.initListeners();
    }

    public ClassPath getBootPath() {
        return this.bootPath;
    }

    public ClassPath getCompilePath() {
        return this.compilePath;
    }

    public ClassPath getSourcePath() {
        return this.sourcePath;
    }

    public FileObject getApplicationFacesConfig() {
        List<FileObject> list = this.getConfigFilesImpl();
        if (list.size() == 0) {
            return null;
        }
        FileObject fileObject = list.iterator().next();
        FileObject fileObject2 = this.module.getDocumentBase();
        if (fileObject2 == null) {
            return null;
        }
        FileObject fileObject3 = fileObject2.getFileObject(DEFAULT_FACES_CONFIG_PATH);
        if (fileObject3 != null && fileObject3.equals(fileObject)) {
            return fileObject;
        }
        return null;
    }

    public List<FileObject> getApplicationConfigurationResources() {
        List<FileObject> list = this.getConfigFilesImpl();
        FileObject fileObject = this.getApplicationFacesConfig();
        if (fileObject != null) {
            return list.subList(1, list.size());
        }
        return list;
    }

    private void collectConfigurationFilesFromClassPath(ClassPath classPath, List<FileObject> list, List<FileObject> list2) {
        for (ClassPath.Entry entry : classPath.entries()) {
            FileObject[] fileObjectArray;
            if (entry.isValid()) {
                fileObjectArray = new FileObject[]{entry.getRoot()};
            } else {
                FileObject[] fileObjectArray2 = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                fileObjectArray = fileObjectArray2.getRoots();
            }
            for (FileObject fileObject : fileObjectArray) {
                FileObject[] fileObjectArray3;
                list2.add(fileObject);
                FileObject fileObject2 = fileObject.getFileObject(META_INF);
                if (fileObject2 == null) continue;
                for (FileObject fileObject3 : fileObjectArray3 = fileObject2.getChildren()) {
                    String string = fileObject3.getNameExt();
                    if (!string.equals(FACES_CONFIG) && !string.endsWith(FACES_CONFIG_SUFFIX) || list.contains(fileObject3)) continue;
                    list.add(fileObject3);
                }
            }
        }
    }

    private synchronized List<FileObject> getConfigFiles() {
        return this.configFiles;
    }

    private synchronized void setConfigFiles(List<FileObject> list, List<FileObject> list2) {
        this.configFiles = list;
        this.configRoots = list2;
    }

    private synchronized List<FileObject> getConfigRoots() {
        return this.configRoots;
    }

    private List<FileObject> getConfigFilesImpl() {
        List<FileObject> list = this.getConfigFiles();
        if (list != null) {
            return list;
        }
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles(this.module);
        list = new LinkedList<FileObject>(Arrays.asList(fileObjectArray));
        this.configRoots = new LinkedList<FileObject>();
        if (this.module.getDocumentBase() != null) {
            this.configRoots.add(this.module.getDocumentBase());
        }
        this.collectConfigurationFilesFromClassPath(this.sourcePath, list, this.configRoots);
        this.collectConfigurationFilesFromClassPath(this.compilePath, list, this.configRoots);
        this.setConfigFiles(list, this.configRoots);
        return list;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireChange() {
        this.setConfigFiles(null, Collections.EMPTY_LIST);
        this.changeSupport.firePropertyChange("configFiles", null, null);
    }

    private void initListeners() {
        Listener listener = new Listener();
        this.sourcePath.addPropertyChangeListener((PropertyChangeListener)listener);
        this.compilePath.addPropertyChangeListener((PropertyChangeListener)listener);
        FileUtil.addFileChangeListener((FileChangeListener)listener);
    }

    private class Listener
    implements FileChangeListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("entries")) {
                ModelUnit.this.fireChange();
            }
        }

        private boolean isRelevantFileEvent(FileEvent fileEvent) {
            boolean bl;
            String string = fileEvent.getFile().getPath();
            boolean bl2 = bl = string.endsWith("/web.xml") || string.endsWith("/WEB-INF/faces-config.xml") || string.endsWith("/META-INF/faces-config.xml") || string.endsWith(ModelUnit.FACES_CONFIG_SUFFIX) && fileEvent.getFile().getParent() != null && fileEvent.getFile().getParent().getNameExt().equals(ModelUnit.META_INF);
            if (!bl && fileEvent instanceof FileRenameEvent) {
                FileRenameEvent fileRenameEvent = (FileRenameEvent)fileEvent;
                boolean bl3 = bl = (fileRenameEvent.getName().equals("faces-config") || fileRenameEvent.getName().endsWith(".faces-config") || fileRenameEvent.getName().endsWith("web.xml")) && fileRenameEvent.getExt().equals("xml");
            }
            if (bl) {
                bl = false;
                for (FileObject fileObject : ModelUnit.this.getConfigRoots()) {
                    if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileEvent.getFile())) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (this.isRelevantFileEvent(fileEvent)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            if (this.isRelevantFileEvent(fileEvent)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (this.isRelevantFileEvent(fileEvent)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (this.isRelevantFileEvent((FileEvent)fileRenameEvent)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

