/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.wizards.CompositeComponentWizardPanel;
import org.netbeans.modules.web.wizards.BrowseFolders;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CompositeComponentVisualPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(CompositeComponentVisualPanel.class.getName());
    private Project project;
    private SourceGroup[] folders;
    private WebModule wm;
    private static final String RESOURCES_FOLDER = "resources";
    private static final String COMPONENT_FOLDER = "ezcomp";
    private String expectedExtension;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    private final Pattern FOLDER_NAME_PATTERN = Pattern.compile(".*/(.*)");
    private boolean indirectModification;
    private boolean prefixLocked;
    private static final String COMPOSITE_LIBRARY_NS = "http://java.sun.com/jsf/composite";
    private JButton browseButton;
    private JPanel customPanel;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JPanel fillerPanel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JLabel implSectionLabel;
    private JScrollPane jScrollPane1;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JLabel nameLabel;
    private JLabel pathLabel;
    private JLabel prefixLabel;
    private JTextField prefixTextField;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JEditorPane selectedTextPane;
    private JSeparator targetSeparator;

    public CompositeComponentVisualPanel(Project project, SourceGroup[] sourceGroupArray, String string) {
        this.project = project;
        this.folders = sourceGroupArray;
        this.initComponents();
        this.locationCB.setRenderer(this.CELL_RENDERER);
        if (string != null) {
            try {
                EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/xhtml")).lookup(EditorKit.class);
                Document document = editorKit.createDefaultDocument();
                document.insertString(0, string, null);
                this.selectedTextPane.setEditorKit(editorKit);
                this.selectedTextPane.setDocument(document);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        } else {
            this.selectedTextPane.setEnabled(false);
            this.implSectionLabel.setEnabled(false);
        }
        this.initValues(null, null, null, false);
        this.browseButton.addActionListener(this);
        this.locationCB.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.prefixTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CompositeComponentVisualPanel.this.prefixTextFieldModified();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CompositeComponentVisualPanel.this.prefixTextFieldModified();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CompositeComponentVisualPanel.this.prefixTextFieldModified();
            }
        });
    }

    WebModule getWebModule() {
        return this.wm;
    }

    void initValues(FileObject fileObject, FileObject fileObject2, String string, boolean bl) {
        Object object;
        assert (this.project != null);
        this.prefixLabel.setEnabled(bl);
        this.prefixTextField.setEnabled(bl);
        this.prefixLocked = !bl;
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        this.locationCB.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup sourceGroup = this.getPreselectedGroup(this.folders, fileObject2);
        if (sourceGroup != null) {
            this.locationCB.setSelectedItem(sourceGroup);
            if (fileObject2 != null && fileObject2.getName().equals(RESOURCES_FOLDER)) {
                this.folderTextField.setText(this.getRelativeNativeName(sourceGroup.getRootFolder(), fileObject2) + File.separatorChar + COMPONENT_FOLDER);
            } else {
                this.folderTextField.setText(RESOURCES_FOLDER + File.separatorChar + COMPONENT_FOLDER);
            }
        }
        String string2 = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = string2.length() == 0 ? "" : "." + string2;
        String string3 = null;
        try {
            if (fileObject != null) {
                object = DataObject.find((FileObject)fileObject);
                string3 = object.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string3 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string3);
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(CompositeComponentWizardPanel.class, (String)"LBL_SimpleTargetChooserPanel_Name")});
        if (fileObject != null) {
            object = fileObject.getName();
            if (string == null) {
                string = object;
            }
            if (fileObject2 != null) {
                FileObject fileObject3;
                int n = 0;
                while ((fileObject3 = fileObject2.getFileObject(string, fileObject.getExt())) != null) {
                    string = (String)object + ++n;
                }
            }
            this.documentNameTextField.setText(string);
            this.documentNameTextField.selectAll();
        }
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        for (int i = 0; fileObject != null && i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject) && !sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
            return sourceGroupArray[i];
        }
        if (sourceGroupArray.length > 0) {
            return sourceGroupArray[0];
        }
        return null;
    }

    private String getRelativeNativeName(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null) {
            throw new NullPointerException("null root passed to getRelativeNativeName");
        }
        String string = fileObject2 == null ? "" : FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        return string == null ? "" : string.replace('/', File.separatorChar);
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationCB.getSelectedItem();
    }

    public String getCompositeComponentURI() {
        String string;
        String string2 = this.getTargetFolder();
        if (string2.startsWith(string = "resources/")) {
            return "http://java.sun.com/jsf/composite/" + string2.substring(string.length());
        }
        return null;
    }

    public String getTargetFolder() {
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        return string;
    }

    public String getPrefix() {
        try {
            Document document = this.prefixTextField.getDocument();
            return document.getText(0, document.getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.pathLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.customPanel = new JPanel();
        this.implSectionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.selectedTextPane = new JEditorPane();
        this.fillerPanel = new JPanel();
        this.prefixLabel = new JLabel();
        this.prefixTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_FileName_mnem").charAt(0));
        this.nameLabel.setLabelFor(this.documentNameTextField);
        this.nameLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_JspName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_FileName"));
        this.projectLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Project_mnem").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_Project"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Location_mnem").charAt(0));
        this.locationLabel.setLabelFor(this.locationCB);
        this.locationLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.locationCB, gridBagConstraints);
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_Location"));
        this.folderLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Folder_mnem").charAt(0));
        this.folderLabel.setLabelFor(this.folderTextField);
        this.folderLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_Folder"));
        this.browseButton.setMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"ACSD_Browse"));
        this.pathLabel.setDisplayedMnemonic(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_CreatedFile_mnem").charAt(0));
        this.pathLabel.setLabelFor(this.fileTextField);
        this.pathLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_DESC_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.customPanel.setPreferredSize(new Dimension(400, 180));
        this.customPanel.setLayout(new GridBagLayout());
        this.implSectionLabel.setText(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"LBL_IMPLEMENTATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.customPanel.add((Component)this.implSectionLabel, gridBagConstraints);
        this.selectedTextPane.setEditable(false);
        this.selectedTextPane.setEnabled(false);
        this.selectedTextPane.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.selectedTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.customPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.fillerPanel, gridBagConstraints);
        this.prefixLabel.setText("Prefix:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.prefixTextField, gridBagConstraints);
        this.prefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompositeComponentVisualPanel.class, (String)"A11Y_Library_Prefix"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = (SourceGroup)this.locationCB.getSelectedItem();
            if (sourceGroup == null) {
                return;
            }
            fileObject = BrowseFolders.showDialog((SourceGroup[])new SourceGroup[]{sourceGroup}, DataFolder.class, (String)this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.folderTextField.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.locationCB == actionEvent.getSource()) {
            this.updateCreatedFolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCreatedFolder() {
        SourceGroup sourceGroup = (SourceGroup)this.locationCB.getSelectedItem();
        if (sourceGroup == null) {
            return;
        }
        FileObject fileObject = sourceGroup.getRootFolder();
        if (fileObject == null) {
            return;
        }
        String string = this.folderTextField.getText().trim();
        String string2 = this.documentNameTextField.getText().trim();
        String string3 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/") + string2 + this.expectedExtension;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
        try {
            this.indirectModification = false;
            this.updatePrefix();
        }
        finally {
            this.indirectModification = true;
        }
        this.changeSupport.fireChange();
    }

    private void prefixTextFieldModified() {
        if (this.indirectModification) {
            this.prefixLocked = true;
        }
        this.changeSupport.fireChange();
    }

    private void updatePrefix() {
        Matcher matcher;
        if (!this.prefixLocked && (matcher = this.FOLDER_NAME_PATTERN.matcher(this.folderTextField.getText())).matches() && matcher.groupCount() == 1) {
            String string;
            this.prefixTextField.setText(string.substring(0, (string = matcher.group(1)).length() < 2 ? string.length() : 2));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public String getCreatedFilePath() {
        return this.fileTextField.getText();
    }

    private class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SourceGroup) {
                String string;
                SourceGroup sourceGroup = (SourceGroup)object;
                String string2 = ProjectUtils.getInformation((Project)CompositeComponentVisualPanel.this.project).getDisplayName();
                if (string2.equals(string = sourceGroup.getDisplayName())) {
                    this.setText(string);
                } else {
                    this.setText(MessageFormat.format("{1} - {0}", string, string2, sourceGroup.getRootFolder().getName()));
                }
                this.setIcon(sourceGroup.getIcon(false));
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

