/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.facesmodel.Description;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ManagedBeanIterator
implements TemplateWizard.Iterator {
    private int index;
    private ManagedBeanPanel managedBeanPanel;
    private transient WizardDescriptor.Panel[] panels;
    private transient boolean debug = false;
    private static final Map<ManagedBean.Scope, String> FACES_SCOPE = new HashMap<ManagedBean.Scope, String>();
    private static final Map<String, String> CDI_SCOPE;
    private static final Map<NamedScope, String> NAMED_SCOPE;

    public void initialize(TemplateWizard templateWizard) {
        WizardDescriptor.Panel panel;
        if (this.debug) {
            this.log("initialize");
        }
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        DataFolder dataFolder = null;
        try {
            dataFolder = templateWizard.getTargetFolder();
        }
        catch (IOException iOException) {
            dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (this.debug) {
            this.log("\tproject: " + project);
            this.log("\ttargetFolder: " + dataFolder);
            this.log("\tsourceGroups.length: " + sourceGroupArray.length);
        }
        this.managedBeanPanel = new ManagedBeanPanel(project, templateWizard);
        if (sourceGroupArray.length == 0) {
            templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanIterator.class, (String)"MSG_No_Sources_found"));
            panel = this.managedBeanPanel;
        } else {
            panel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.managedBeanPanel);
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ManagedBeanIterator.this.managedBeanPanel.updateManagedBeanName((WizardDescriptor.Panel)changeEvent.getSource());
                }
            });
        }
        this.panels = new WizardDescriptor.Panel[]{panel};
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jComponent = (JComponent)this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = jComponent.getName();
            }
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        if (this.debug) {
            this.log("instantiate");
        }
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)templateWizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        String string = (String)templateWizard.getProperty("ConfigFile");
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        fileObject = webModule.getDocumentBase();
        if (string == null && !JSFConfigUtilities.hasJsfFramework(fileObject)) {
            JSFConfigUtilities.extendJsfFramework(fileObject, false);
        }
        String string2 = this.getUniqueName((String)templateWizard.getProperty("Name"), webModule);
        Object object = templateWizard.getProperty("Scope");
        boolean bl = !this.managedBeanPanel.isAddBeanToConfig();
        DataObject dataObject2 = null;
        if (bl && (Utilities.isJavaEE6((TemplateWizard)templateWizard) || JSFUtils.isJSF20(webModule) && JSFUtils.isJavaEE5(templateWizard))) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = Templates.getTargetName((WizardDescriptor)templateWizard);
            if (JSFUtils.isCDIEnabled(webModule)) {
                hashMap.put("CDIEnabled", "true");
                hashMap.put("classAnnotation", "@Named(value=\"" + string2 + "\")");
                hashMap.put("scopeAnnotation", NAMED_SCOPE.get((Object)((NamedScope)((Object)object))).toString());
            } else {
                if (string3.equalsIgnoreCase(string2) && string3.substring(0, 1).toLowerCase().equals(string2.substring(0, 1))) {
                    hashMap.put("classAnnotation", "@ManagedBean");
                } else {
                    hashMap.put("classAnnotation", "@ManagedBean(name=\"" + string2 + "\")");
                }
                hashMap.put("scopeAnnotation", FACES_SCOPE.get((Object)((ManagedBean.Scope)((Object)object))).toString());
            }
            dataObject2 = dataObject.createFromTemplate(dataFolder, string3, hashMap);
        } else {
            FileObject fileObject3 = fileObject.getFileObject(string);
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObject3, true).getRootComponent();
            JSFBeanCache.getBeans(webModule);
            dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)templateWizard));
            ManagedBean managedBean = facesConfig.getModel().getFactory().createManagedBean();
            String string4 = Templates.getTargetName((WizardDescriptor)templateWizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            String string5 = null;
            FileObject fileObject4 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            for (int i = 0; i < sourceGroupArray.length && string5 == null && (string5 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject4)) == null; ++i) {
            }
            string5 = string5 != null ? string5.replace('/', '.') : "";
            String string6 = null;
            string6 = string5.length() > 0 ? string5 + "." + string4 : string4;
            managedBean.setManagedBeanName(string2);
            managedBean.setManagedBeanClass(string6);
            if (object == null) {
                object = ManagedBean.Scope.REQUEST;
            }
            managedBean.setManagedBeanScope((ManagedBean.Scope)((Object)object));
            String string7 = (String)templateWizard.getProperty("Description");
            if (string7 != null && string7.length() > 0) {
                Description description = managedBean.getModel().getFactory().createDescription();
                description.setValue(string7);
                managedBean.addDescription(description);
            }
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean(managedBean);
            facesConfig.getModel().endTransaction();
            facesConfig.getModel().sync();
        }
        return Collections.singleton(dataObject2);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(ManagedBeanIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private void log(String string) {
        System.out.println("ActionIterator:: \t" + string);
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    private void replaceInDocument(Document document, String string, String string2) {
        AbstractDocument abstractDocument = (AbstractDocument)document;
        int n = string.length();
        try {
            String string3 = abstractDocument.getText(0, abstractDocument.getLength());
            int n2 = string3.lastIndexOf(string);
            while (n2 >= 0) {
                abstractDocument.replace(n2, n, string2, null);
                string3 = string3.substring(0, n2);
                n2 = string3.lastIndexOf(string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String getUniqueName(String string, WebModule webModule) {
        String string2 = string;
        int n = 0;
        for (FacesManagedBean facesManagedBean : JSFBeanCache.getBeans(webModule)) {
            if (!string2.equals(facesManagedBean.getManagedBeanName())) continue;
            string2 = string + ++n;
        }
        return string2;
    }

    static {
        FACES_SCOPE.put(ManagedBean.Scope.APPLICATION, "ApplicationScoped");
        FACES_SCOPE.put(ManagedBean.Scope.NONE, "NoneScoped");
        FACES_SCOPE.put(ManagedBean.Scope.REQUEST, "RequestScoped");
        FACES_SCOPE.put(ManagedBean.Scope.SESSION, "SessionScoped");
        FACES_SCOPE.put(ManagedBean.Scope.VIEW, "ViewScoped");
        CDI_SCOPE = new HashMap<String, String>();
        CDI_SCOPE.put(null, "Dependent");
        NAMED_SCOPE = new HashMap<NamedScope, String>();
        NAMED_SCOPE.put(NamedScope.DEPENDENT, "Dependent");
        NAMED_SCOPE.put(NamedScope.APPLICATION, "ApplicationScoped");
        NAMED_SCOPE.put(NamedScope.REQUEST, "RequestScoped");
        NAMED_SCOPE.put(NamedScope.SESSION, "SessionScoped");
        NAMED_SCOPE.put(NamedScope.CONVERSATION, "ConversationScoped");
    }

    protected static enum NamedScope {
        DEPENDENT("dependent"),
        APPLICATION("application"),
        REQUEST("request"),
        SESSION("session"),
        CONVERSATION("conversation");

        private String scope;

        private NamedScope(String string2) {
            this.scope = string2;
        }

        public String toString() {
            return this.scope;
        }
    }
}

