/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;

public final class SettingsUtils {
    private SettingsUtils() {
    }

    public static void merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        if (dominant == null || recessive == null) {
            return;
        }
        recessive.setSourceLevel(recessiveSourceLevel);
        ArrayList<String> dominantActiveProfiles = dominant.getActiveProfiles();
        List recessiveActiveProfiles = recessive.getActiveProfiles();
        if (recessiveActiveProfiles != null) {
            if (dominantActiveProfiles == null) {
                dominantActiveProfiles = new ArrayList<String>();
                dominant.setActiveProfiles(dominantActiveProfiles);
            }
            for (String profileId : recessiveActiveProfiles) {
                if (dominantActiveProfiles.contains(profileId)) continue;
                dominantActiveProfiles.add(profileId);
            }
        }
        ArrayList<String> dominantPluginGroupIds = dominant.getPluginGroups();
        List recessivePluginGroupIds = recessive.getPluginGroups();
        if (recessivePluginGroupIds != null) {
            if (dominantPluginGroupIds == null) {
                dominantPluginGroupIds = new ArrayList<String>();
                dominant.setPluginGroups(dominantPluginGroupIds);
            }
            for (String pluginGroupId : recessivePluginGroupIds) {
                if (dominantPluginGroupIds.contains(pluginGroupId)) continue;
                dominantPluginGroupIds.add(pluginGroupId);
            }
        }
        if (StringUtils.isEmpty(dominant.getLocalRepository())) {
            dominant.setLocalRepository(recessive.getLocalRepository());
        }
        SettingsUtils.shallowMergeById(dominant.getMirrors(), recessive.getMirrors(), recessiveSourceLevel);
        SettingsUtils.shallowMergeById(dominant.getServers(), recessive.getServers(), recessiveSourceLevel);
        SettingsUtils.shallowMergeById(dominant.getProxies(), recessive.getProxies(), recessiveSourceLevel);
        SettingsUtils.shallowMergeById(dominant.getProfiles(), recessive.getProfiles(), recessiveSourceLevel);
    }

    private static void shallowMergeById(List dominant, List recessive, String recessiveSourceLevel) {
        Map dominantById = SettingsUtils.mapById(dominant);
        for (IdentifiableBase identifiable : recessive) {
            if (dominantById.containsKey(identifiable.getId())) continue;
            identifiable.setSourceLevel(recessiveSourceLevel);
            dominant.add(identifiable);
        }
    }

    private static Map mapById(List identifiables) {
        HashMap<String, IdentifiableBase> byId = new HashMap<String, IdentifiableBase>();
        for (IdentifiableBase identifiable : identifiables) {
            byId.put(identifiable.getId(), identifiable);
        }
        return byId;
    }

    public static org.apache.maven.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(settingsProfile.getId());
        profile.setSource("settings.xml");
        Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            ActivationOS settingsOs;
            org.apache.maven.model.Activation activation = new org.apache.maven.model.Activation();
            activation.setActiveByDefault(settingsActivation.isActiveByDefault());
            activation.setJdk(settingsActivation.getJdk());
            ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                org.apache.maven.model.ActivationProperty prop = new org.apache.maven.model.ActivationProperty();
                prop.setName(settingsProp.getName());
                prop.setValue(settingsProp.getValue());
                activation.setProperty(prop);
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                org.apache.maven.model.ActivationOS os = new org.apache.maven.model.ActivationOS();
                os.setArch(settingsOs.getArch());
                os.setFamily(settingsOs.getFamily());
                os.setName(settingsOs.getName());
                os.setVersion(settingsOs.getVersion());
                activation.setOs(os);
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                org.apache.maven.model.ActivationFile file = new org.apache.maven.model.ActivationFile();
                file.setExists(settingsFile.getExists());
                file.setMissing(settingsFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(settingsProfile.getProperties());
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            Iterator it = repos.iterator();
            while (it.hasNext()) {
                profile.addRepository(SettingsUtils.convertFromSettingsRepository((Repository)it.next()));
            }
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            Iterator it = pluginRepos.iterator();
            while (it.hasNext()) {
                profile.addPluginRepository(SettingsUtils.convertFromSettingsRepository((Repository)it.next()));
            }
        }
        return profile;
    }

    private static org.apache.maven.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(settingsRepo.getId());
        repo.setLayout(settingsRepo.getLayout());
        repo.setName(settingsRepo.getName());
        repo.setUrl(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.setSnapshots(SettingsUtils.convertRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.setReleases(SettingsUtils.convertRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo;
    }

    private static org.apache.maven.model.RepositoryPolicy convertRepositoryPolicy(RepositoryPolicy settingsPolicy) {
        org.apache.maven.model.RepositoryPolicy policy = new org.apache.maven.model.RepositoryPolicy();
        policy.setEnabled(settingsPolicy.isEnabled());
        policy.setUpdatePolicy(settingsPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(settingsPolicy.getChecksumPolicy());
        return policy;
    }
}

