/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.execution.ErrorParser;
import org.netbeans.modules.cnd.toolchain.execution.OutputListenerFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class GCCErrorParser
extends ErrorParser {
    private final List<Pattern> GCC_ERROR_SCANNER = new ArrayList<Pattern>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private Pattern GCC_DIRECTORY_ENTER;
    private Pattern GCC_DIRECTORY_LEAVE;
    private Pattern GCC_DIRECTORY_CD;
    private Pattern GCC_DIRECTORY_MAKE_ALL;
    private Pattern GCC_STACK_HEADER;
    private Pattern GCC_STACK_NEXT;
    private Stack<FileObject> relativesTo = new Stack();
    private Stack<Integer> relativesLevel = new Stack();
    private ArrayList<StackIncludeItem> errorInludes = new ArrayList();
    private boolean isEntered;
    private final OutputListenerFactory listenerFactory = new OutputListenerFactory();

    public GCCErrorParser(CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
        super(execEnv, relativeTo);
        this.relativesTo.push(relativeTo);
        this.relativesLevel.push(0);
        this.isEntered = false;
        this.init(flavor);
    }

    private void init(CompilerFlavor flavor) {
        ToolchainManager.ScannerDescriptor scanner = flavor.getToolchainDescriptor().getScanner();
        if (scanner.getEnterDirectoryPattern() != null) {
            this.GCC_DIRECTORY_ENTER = Pattern.compile(scanner.getEnterDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_ENTER);
        }
        if (scanner.getLeaveDirectoryPattern() != null) {
            this.GCC_DIRECTORY_LEAVE = Pattern.compile(scanner.getLeaveDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_LEAVE);
        }
        if (scanner.getChangeDirectoryPattern() != null) {
            this.GCC_DIRECTORY_CD = Pattern.compile(scanner.getChangeDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_CD);
        }
        if (scanner.getChangeDirectoryPattern() != null) {
            this.GCC_DIRECTORY_MAKE_ALL = Pattern.compile(scanner.getMakeAllInDirectoryPattern());
            this.patterns.add(this.GCC_DIRECTORY_MAKE_ALL);
        }
        if (scanner.getStackHeaderPattern() != null && scanner.getStackHeaderPattern() != null) {
            this.GCC_STACK_HEADER = Pattern.compile(scanner.getStackHeaderPattern());
            this.patterns.add(this.GCC_STACK_HEADER);
            this.GCC_STACK_NEXT = Pattern.compile(scanner.getStackHeaderPattern());
            this.patterns.add(this.GCC_STACK_NEXT);
        }
        for (ToolchainManager.ScannerPattern s : scanner.getPatterns()) {
            Pattern pattern = Pattern.compile(s.getPattern());
            this.GCC_ERROR_SCANNER.add(pattern);
            this.patterns.add(pattern);
        }
    }

    private void popPath() {
        if (this.relativesTo.size() > 1) {
            this.relativesTo.pop();
        }
    }

    private void popLevel() {
        if (this.relativesLevel.size() > 1) {
            this.relativesLevel.pop();
        }
    }

    @Override
    public ErrorParserProvider.Result handleLine(String line) throws IOException {
        for (Pattern p : this.patterns) {
            Matcher m = p.matcher(line);
            boolean found = m.find();
            if (!found || m.start() != 0) continue;
            return this.handleLine(line, m);
        }
        return null;
    }

    private ErrorParserProvider.Result handleLine(String line, Matcher m) throws IOException {
        if (m.pattern() == this.GCC_DIRECTORY_ENTER || m.pattern() == this.GCC_DIRECTORY_LEAVE) {
            String levelString = m.group(1);
            int level = levelString == null ? 0 : Integer.valueOf(levelString);
            int baseLavel = this.relativesLevel.peek();
            String directory = m.group(2);
            if (level > baseLavel) {
                this.isEntered = true;
                this.relativesLevel.push(level);
                this.isEntered = true;
            } else if (level == baseLavel) {
                this.isEntered = !this.isEntered;
            } else {
                this.isEntered = false;
                this.popLevel();
            }
            if (this.isEntered) {
                FileObject relativeDir;
                if (!ToolUtils.isPathAbsolute(directory) && this.relativeTo != null && this.relativeTo.isFolder()) {
                    directory = this.relativeTo.getURL().getPath() + File.separator + directory;
                }
                if ((relativeDir = this.resolveFile(directory)) != null) {
                    this.relativesTo.push(relativeDir);
                }
                return ErrorParserProvider.NO_RESULT;
            }
            this.popPath();
            return ErrorParserProvider.NO_RESULT;
        }
        if (m.pattern() == this.GCC_DIRECTORY_CD) {
            FileObject relativeDir;
            String directory = this.trimQuotes(m.group(1));
            if (!ToolUtils.isPathAbsolute(directory) && this.relativeTo != null && this.relativeTo.isFolder()) {
                directory = this.relativeTo.getURL().getPath() + File.separator + directory;
            }
            if ((relativeDir = this.resolveFile(directory)) != null) {
                this.relativesTo.push(relativeDir);
            }
            return ErrorParserProvider.NO_RESULT;
        }
        if (m.pattern() == this.GCC_DIRECTORY_MAKE_ALL) {
            FileObject relativeDir = this.relativesTo.peek();
            String directory = m.group(1);
            if (!ToolUtils.isPathAbsolute(directory) && relativeDir != null && relativeDir.isFolder()) {
                directory = relativeDir.getURL().getPath() + File.separator + directory;
            }
            if ((relativeDir = this.resolveFile(directory)) != null) {
                this.relativesTo.push(relativeDir);
            }
            return ErrorParserProvider.NO_RESULT;
        }
        if (m.pattern() == this.GCC_STACK_HEADER) {
            ErrorParserProvider.Results res = new ErrorParserProvider.Results();
            for (StackIncludeItem item : this.errorInludes) {
                res.add(item.line, null);
            }
            this.errorInludes.clear();
            try {
                FileObject fo;
                String file = m.group(1);
                Integer lineNumber = Integer.valueOf(m.group(2));
                FileObject relativeDir = this.relativesTo.peek();
                if (relativeDir != null && (fo = this.resolveRelativePath(relativeDir, file)) != null) {
                    this.errorInludes.add(new StackIncludeItem(fo, line, lineNumber - 1));
                    return res;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.errorInludes.add(new StackIncludeItem(null, line, 0));
            return res;
        }
        if (m.pattern() == this.GCC_STACK_NEXT) {
            try {
                FileObject fo;
                String file = m.group(1);
                Integer lineNumber = Integer.valueOf(m.group(2));
                FileObject relativeDir = this.relativesTo.peek();
                if (relativeDir != null && (fo = this.resolveRelativePath(relativeDir, file)) != null) {
                    this.errorInludes.add(new StackIncludeItem(fo, line, lineNumber - 1));
                    return new ErrorParserProvider.Results();
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.errorInludes.add(new StackIncludeItem(null, line, 0));
            return new ErrorParserProvider.Results();
        }
        if (this.GCC_ERROR_SCANNER.contains(m.pattern())) {
            ErrorParserProvider.Results res = new ErrorParserProvider.Results();
            try {
                String file = m.group(1);
                Integer lineNumber = Integer.valueOf(m.group(2));
                FileObject relativeDir = this.relativesTo.peek();
                if (relativeDir != null) {
                    boolean important;
                    FileObject fo = this.resolveRelativePath(relativeDir, file);
                    boolean bl = important = m.group(3).indexOf("error") != -1;
                    if (fo != null) {
                        for (StackIncludeItem item : this.errorInludes) {
                            if (item.fo != null) {
                                res.add(item.line, this.listenerFactory.register(item.fo, item.lineNumber, important, NbBundle.getMessage(GCCErrorParser.class, (String)"HINT_IncludedFrom")));
                                continue;
                            }
                            res.add(item.line, null);
                        }
                        this.errorInludes.clear();
                        String description = null;
                        if (m.groupCount() <= 4) {
                            description = m.group(4);
                        }
                        res.add(line, this.listenerFactory.register(fo, lineNumber - 1, important, description));
                        return res;
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            for (StackIncludeItem item : this.errorInludes) {
                res.add(item.line, null);
            }
            this.errorInludes.clear();
            res.add(line, null);
            return res;
        }
        throw new IllegalArgumentException("Unknown pattern: " + m.pattern().pattern());
    }

    private String trimQuotes(String s) {
        if (s.length() > 2) {
            if (s.startsWith("\"") && s.endsWith("\"")) {
                return s.substring(1, s.length() - 1);
            }
            if (s.startsWith("'") && s.endsWith("'")) {
                return s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    private static class StackIncludeItem {
        private FileObject fo;
        private String line;
        private int lineNumber;

        private StackIncludeItem(FileObject fo, String line, int lineNumber) {
            this.fo = fo;
            this.line = line;
            this.lineNumber = lineNumber;
        }
    }
}

