/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DebuggerChooserConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.RequiredProjectsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.CompilerSetNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.DevelopmentHostNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.RequiredProjectsNodeProp;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MakeConfiguration
extends Configuration {
    public static final String NBPROJECT_FOLDER = "nbproject";
    public static final String PROJECT_XML = "project.xml";
    public static final String CONFIGURATIONS_XML = "configurations.xml";
    public static final String MAKEFILE_IMPL = "Makefile-impl.mk";
    public static final String BUILD_FOLDER = "build";
    public static final String DIST_FOLDER = "dist";
    public static final String EXT_FOLDER = "_ext";
    public static final String OBJECTDIR_MACRO_NAME = "OBJECTDIR";
    public static final String OBJECTDIR_MACRO = "${OBJECTDIR}";
    private static String[] TYPE_NAMES_UNMANAGED = new String[]{MakeConfiguration.getString("MakefileName")};
    private static String[] TYPE_NAMES_MANAGED = new String[]{MakeConfiguration.getString("ApplicationName"), MakeConfiguration.getString("DynamicLibraryName"), MakeConfiguration.getString("StaticLibraryName"), MakeConfiguration.getString("QtApplicationName"), MakeConfiguration.getString("QtDynamicLibraryName"), MakeConfiguration.getString("QtStaticLibraryName")};
    public static final int TYPE_MAKEFILE = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    public static final int TYPE_QT_APPLICATION = 4;
    public static final int TYPE_QT_DYNAMIC_LIB = 5;
    public static final int TYPE_QT_STATIC_LIB = 6;
    private IntConfiguration configurationType;
    private MakefileConfiguration makefileConfiguration;
    private CompilerSet2Configuration compilerSet;
    private LanguageBooleanConfiguration cRequired;
    private LanguageBooleanConfiguration cppRequired;
    private LanguageBooleanConfiguration fortranRequired;
    private LanguageBooleanConfiguration assemblerRequired;
    private DevelopmentHostConfiguration developmentHost;
    private BooleanConfiguration dependencyChecking;
    private BooleanConfiguration rebuildPropChanged;
    private CCompilerConfiguration cCompilerConfiguration;
    private CCCompilerConfiguration ccCompilerConfiguration;
    private FortranCompilerConfiguration fortranCompilerConfiguration;
    private AssemblerConfiguration assemblerConfiguration;
    private LinkerConfiguration linkerConfiguration;
    private ArchiverConfiguration archiverConfiguration;
    private PackagingConfiguration packagingConfiguration;
    private RequiredProjectsConfiguration requiredProjectsConfiguration;
    private DebuggerChooserConfiguration debuggerChooserConfiguration;
    private QmakeConfiguration qmakeConfiguration;
    private boolean languagesDirty = true;

    public MakeConfiguration(String baseDir, String name, int configurationTypeValue) {
        this(baseDir, name, configurationTypeValue, null);
    }

    public MakeConfiguration(String baseDir, String name, int configurationTypeValue, String hostUID) {
        this(baseDir, name, configurationTypeValue, hostUID, null);
    }

    public MakeConfiguration(String baseDir, String name, int configurationTypeValue, String hostUID, CompilerSet hostCS) {
        super(baseDir, name);
        hostUID = hostUID == null ? CppUtils.getDefaultDevelopmentHost() : hostUID;
        this.configurationType = configurationTypeValue == 0 ? new IntConfiguration(null, configurationTypeValue, TYPE_NAMES_UNMANAGED, null) : new ManagedIntConfiguration(null, configurationTypeValue, TYPE_NAMES_MANAGED, null);
        this.developmentHost = new DevelopmentHostConfiguration(ExecutionEnvironmentFactory.fromUniqueID((String)hostUID));
        CompilerSet defCS = hostCS != null ? hostCS : CompilerSetManager.get((ExecutionEnvironment)this.developmentHost.getExecutionEnvironment()).getDefaultCompilerSet();
        this.compilerSet = new CompilerSet2Configuration(this.developmentHost, defCS);
        this.cRequired = new LanguageBooleanConfiguration();
        this.cppRequired = new LanguageBooleanConfiguration();
        this.fortranRequired = new LanguageBooleanConfiguration();
        this.assemblerRequired = new LanguageBooleanConfiguration();
        this.makefileConfiguration = new MakefileConfiguration(this);
        this.dependencyChecking = new BooleanConfiguration(this.isMakefileConfiguration() ? false : MakeProjectOptions.getDepencyChecking());
        this.rebuildPropChanged = new BooleanConfiguration(this.isMakefileConfiguration() ? false : MakeProjectOptions.getRebuildPropChanged());
        this.cCompilerConfiguration = new CCompilerConfiguration(baseDir, null);
        this.ccCompilerConfiguration = new CCCompilerConfiguration(baseDir, null);
        this.fortranCompilerConfiguration = new FortranCompilerConfiguration(baseDir, null);
        this.assemblerConfiguration = new AssemblerConfiguration(baseDir, null);
        this.linkerConfiguration = new LinkerConfiguration(this);
        this.archiverConfiguration = new ArchiverConfiguration(this);
        this.packagingConfiguration = new PackagingConfiguration(this);
        this.requiredProjectsConfiguration = new RequiredProjectsConfiguration();
        this.debuggerChooserConfiguration = new DebuggerChooserConfiguration(Lookup.EMPTY);
        this.qmakeConfiguration = new QmakeConfiguration(this);
        this.developmentHost.addPropertyChangeListener(this.compilerSet);
    }

    public void setMakefileConfiguration(MakefileConfiguration makefileConfiguration) {
        this.makefileConfiguration = makefileConfiguration;
        this.makefileConfiguration.setMakeConfiguration(this);
    }

    public MakefileConfiguration getMakefileConfiguration() {
        return this.makefileConfiguration;
    }

    public IntConfiguration getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(IntConfiguration configurationType) {
        this.configurationType = configurationType;
    }

    public BooleanConfiguration getDependencyChecking() {
        return this.dependencyChecking;
    }

    public void setDependencyChecking(BooleanConfiguration dependencyChecking) {
        this.dependencyChecking = dependencyChecking;
    }

    public BooleanConfiguration getRebuildPropChanged() {
        return this.rebuildPropChanged;
    }

    public void setRebuildPropChanged(BooleanConfiguration rebuildPropChanged) {
        this.rebuildPropChanged = rebuildPropChanged;
    }

    public CompilerSet2Configuration getCompilerSet() {
        return this.compilerSet;
    }

    public void setCompilerSet(CompilerSet2Configuration compilerSet) {
        this.compilerSet = compilerSet;
    }

    public LanguageBooleanConfiguration getCRequired() {
        return this.cRequired;
    }

    public LanguageBooleanConfiguration getCppRequired() {
        return this.cppRequired;
    }

    public LanguageBooleanConfiguration getFortranRequired() {
        return this.fortranRequired;
    }

    public void setCRequired(LanguageBooleanConfiguration cRequired) {
        this.cRequired = cRequired;
    }

    public void setCppRequired(LanguageBooleanConfiguration cppRequired) {
        this.cppRequired = cppRequired;
    }

    public void setFortranRequired(LanguageBooleanConfiguration fortranRequired) {
        this.fortranRequired = fortranRequired;
    }

    public LanguageBooleanConfiguration getAssemblerRequired() {
        return this.assemblerRequired;
    }

    public void setAssemblerRequired(LanguageBooleanConfiguration assemblerRequired) {
        this.assemblerRequired = assemblerRequired;
    }

    public PlatformInfo getPlatformInfo() {
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)this.getDevelopmentHost().getExecutionEnvironment());
        return platformInfo;
    }

    public DevelopmentHostConfiguration getDevelopmentHost() {
        return this.developmentHost;
    }

    public void setDevelopmentHost(DevelopmentHostConfiguration developmentHost) {
        this.developmentHost = developmentHost;
    }

    public boolean isApplicationConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompileConfiguration() {
        return this.getConfigurationType().getValue() == 1 || this.getConfigurationType().getValue() == 2 || this.getConfigurationType().getValue() == 3;
    }

    public boolean isLibraryConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isLinkerConfiguration() {
        return this.getConfigurationType().getValue() == 1 || this.getConfigurationType().getValue() == 2;
    }

    public final boolean isMakefileConfiguration() {
        return this.getConfigurationType().getValue() == 0;
    }

    public boolean isDynamicLibraryConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isArchiverConfiguration() {
        return this.getConfigurationType().getValue() == 3;
    }

    public boolean isQmakeConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.cCompilerConfiguration = cCompilerConfiguration;
    }

    public CCompilerConfiguration getCCompilerConfiguration() {
        return this.cCompilerConfiguration;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration ccCompilerConfiguration) {
        this.ccCompilerConfiguration = ccCompilerConfiguration;
    }

    public CCCompilerConfiguration getCCCompilerConfiguration() {
        return this.ccCompilerConfiguration;
    }

    public void setFortranCompilerConfiguration(FortranCompilerConfiguration fortranCompilerConfiguration) {
        this.fortranCompilerConfiguration = fortranCompilerConfiguration;
    }

    public FortranCompilerConfiguration getFortranCompilerConfiguration() {
        return this.fortranCompilerConfiguration;
    }

    public void setAssemblerConfiguration(AssemblerConfiguration assemblerConfiguration) {
        this.assemblerConfiguration = assemblerConfiguration;
    }

    public AssemblerConfiguration getAssemblerConfiguration() {
        return this.assemblerConfiguration;
    }

    public void setLinkerConfiguration(LinkerConfiguration linkerConfiguration) {
        this.linkerConfiguration = linkerConfiguration;
        this.linkerConfiguration.setMakeConfiguration(this);
    }

    public LinkerConfiguration getLinkerConfiguration() {
        return this.linkerConfiguration;
    }

    public void setArchiverConfiguration(ArchiverConfiguration archiverConfiguration) {
        this.archiverConfiguration = archiverConfiguration;
        this.archiverConfiguration.setMakeConfiguration(this);
    }

    public ArchiverConfiguration getArchiverConfiguration() {
        return this.archiverConfiguration;
    }

    public void setPackagingConfiguration(PackagingConfiguration packagingConfiguration) {
        this.packagingConfiguration = packagingConfiguration;
        this.packagingConfiguration.setMakeConfiguration(this);
    }

    public PackagingConfiguration getPackagingConfiguration() {
        return this.packagingConfiguration;
    }

    public RequiredProjectsConfiguration getRequiredProjectsConfiguration() {
        return this.requiredProjectsConfiguration;
    }

    public void setRequiredProjectsConfiguration(RequiredProjectsConfiguration requiredProjectsConfiguration) {
        this.requiredProjectsConfiguration = requiredProjectsConfiguration;
    }

    public DebuggerChooserConfiguration getDebuggerChooserConfiguration() {
        return this.debuggerChooserConfiguration;
    }

    public void setDebuggerChooserConfiguration(DebuggerChooserConfiguration debuggerChooserConfiguration) {
        this.debuggerChooserConfiguration = debuggerChooserConfiguration;
    }

    public QmakeConfiguration getQmakeConfiguration() {
        return this.qmakeConfiguration;
    }

    public void setQmakeConfiguration(QmakeConfiguration qmakeConfiguration) {
        this.qmakeConfiguration = qmakeConfiguration;
    }

    @Override
    public void assign(Configuration conf) {
        MakeConfiguration makeConf = (MakeConfiguration)conf;
        this.setName(makeConf.getName());
        this.setBaseDir(makeConf.getBaseDir());
        this.getConfigurationType().assign(makeConf.getConfigurationType());
        this.getDevelopmentHost().assign(makeConf.getDevelopmentHost());
        this.getCompilerSet().assign(makeConf.getCompilerSet());
        this.getCRequired().assign(makeConf.getCRequired());
        this.getCppRequired().assign(makeConf.getCppRequired());
        this.getFortranRequired().assign(makeConf.getFortranRequired());
        this.getAssemblerRequired().assign(makeConf.getAssemblerRequired());
        this.getDependencyChecking().assign(makeConf.getDependencyChecking());
        this.getRebuildPropChanged().assign(makeConf.getRebuildPropChanged());
        this.getMakefileConfiguration().assign(makeConf.getMakefileConfiguration());
        this.getCCompilerConfiguration().assign(makeConf.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(makeConf.getCCCompilerConfiguration());
        this.getFortranCompilerConfiguration().assign(makeConf.getFortranCompilerConfiguration());
        this.getAssemblerConfiguration().assign(makeConf.getAssemblerConfiguration());
        this.getLinkerConfiguration().assign(makeConf.getLinkerConfiguration());
        this.getArchiverConfiguration().assign(makeConf.getArchiverConfiguration());
        this.getPackagingConfiguration().assign(makeConf.getPackagingConfiguration());
        this.getRequiredProjectsConfiguration().assign(makeConf.getRequiredProjectsConfiguration());
        this.getDebuggerChooserConfiguration().assign(makeConf.getDebuggerChooserConfiguration());
        this.getQmakeConfiguration().assign(makeConf.getQmakeConfiguration());
        ConfigurationAuxObject[] auxs = this.getAuxObjects();
        for (int i = 0; i < auxs.length; ++i) {
            String id = auxs[i].getId();
            ConfigurationAuxObject object = conf.getAuxObject(id);
            if (object != null) {
                auxs[i].assign(object);
                continue;
            }
            System.err.println("Configuration - assign: Object ID " + id + " do not found");
        }
    }

    @Override
    public Configuration cloneConf() {
        return (Configuration)this.clone();
    }

    @Override
    public Configuration copy() {
        MakeConfiguration copy = new MakeConfiguration(this.getBaseDir(), this.getName(), this.getConfigurationType().getValue());
        copy.assign(this);
        ConfigurationAuxObject[] auxs = this.getAuxObjects();
        ArrayList<ConfigurationAuxObject> copiedAuxs = new ArrayList<ConfigurationAuxObject>();
        for (int i = 0; i < auxs.length; ++i) {
            if (auxs[i] instanceof ItemConfiguration) {
                copiedAuxs.add(((ItemConfiguration)auxs[i]).copy(copy));
                continue;
            }
            if (auxs[i] instanceof FolderConfiguration) {
                copiedAuxs.add(((FolderConfiguration)auxs[i]).copy(copy));
                continue;
            }
            String id = auxs[i].getId();
            ConfigurationAuxObject copyAux = copy.getAuxObject(id);
            if (copyAux != null) {
                copyAux.assign(auxs[i]);
                copiedAuxs.add(copyAux);
                continue;
            }
            copiedAuxs.add(auxs[i]);
        }
        copy.setAuxObjects(copiedAuxs);
        this.fixupMasterLinks(copy);
        return copy;
    }

    private void fixupMasterLinks(MakeConfiguration makeConf) {
        FileObject projectDirFO = FileUtil.toFileObject((File)new File(this.getBaseDir()));
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(projectDirFO);
        }
        catch (IOException ioe) {
            return;
        }
        if (project == null) {
            return;
        }
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        Folder root = makeConfigurationDescriptor.getLogicalFolders();
        this.fixupFolderItemLinks(makeConf, root, makeConf.getCCompilerConfiguration(), makeConf.getCCCompilerConfiguration());
    }

    private void fixupFolderItemLinks(MakeConfiguration makeConf, Folder folder, BasicCompilerConfiguration cCompilerConf, BasicCompilerConfiguration ccCompilerConf) {
        if (!folder.isProjectFiles()) {
            return;
        }
        FolderConfiguration folderConfiguration = (FolderConfiguration)makeConf.getAuxObject(folder.getId());
        if (folderConfiguration == null) {
            return;
        }
        if (folderConfiguration.getCCompilerConfiguration() != null) {
            folderConfiguration.getCCompilerConfiguration().setMaster(cCompilerConf);
        }
        if (folderConfiguration.getCCCompilerConfiguration() != null) {
            folderConfiguration.getCCCompilerConfiguration().setMaster(ccCompilerConf);
        }
        for (Item item : folder.getItemsAsArray()) {
            ItemConfiguration itemConfiguration = (ItemConfiguration)makeConf.getAuxObject(item.getId());
            if (itemConfiguration.getCCompilerConfiguration() != null) {
                itemConfiguration.getCCompilerConfiguration().setMaster(folderConfiguration.getCCompilerConfiguration());
                itemConfiguration.getCCompilerConfiguration().fixupMasterLinks(makeConf.getCCompilerConfiguration());
            }
            if (itemConfiguration.getCCCompilerConfiguration() == null) continue;
            itemConfiguration.getCCCompilerConfiguration().setMaster(folderConfiguration.getCCCompilerConfiguration());
            itemConfiguration.getCCCompilerConfiguration().fixupMasterLinks(makeConf.getCCCompilerConfiguration());
        }
        for (EventListener eventListener : folder.getFoldersAsArray()) {
            this.fixupFolderItemLinks(makeConf, (Folder)eventListener, folderConfiguration.getCCompilerConfiguration(), folderConfiguration.getCCCompilerConfiguration());
        }
    }

    public Object clone() {
        MakeConfiguration clone = new MakeConfiguration(this.getBaseDir(), this.getName(), this.getConfigurationType().getValue(), this.getDevelopmentHost().getHostKey());
        super.cloneConf(clone);
        clone.setCloneOf(this);
        DevelopmentHostConfiguration dhconf = this.getDevelopmentHost().clone();
        clone.setDevelopmentHost(dhconf);
        CompilerSet2Configuration csconf = this.getCompilerSet().clone();
        csconf.setDevelopmentHostConfiguration(dhconf);
        clone.setCompilerSet(csconf);
        clone.setCRequired(this.getCRequired().clone());
        clone.setCppRequired(this.getCppRequired().clone());
        clone.setFortranRequired(this.getFortranRequired().clone());
        clone.setAssemblerRequired(this.getAssemblerRequired().clone());
        clone.setMakefileConfiguration(this.getMakefileConfiguration().clone());
        clone.setDependencyChecking(this.getDependencyChecking().clone());
        clone.setRebuildPropChanged(this.getRebuildPropChanged().clone());
        clone.setCCompilerConfiguration(this.getCCompilerConfiguration().clone());
        clone.setCCCompilerConfiguration(this.getCCCompilerConfiguration().clone());
        clone.setFortranCompilerConfiguration(this.getFortranCompilerConfiguration().clone());
        clone.setAssemblerConfiguration(this.getAssemblerConfiguration().clone());
        clone.setLinkerConfiguration(this.getLinkerConfiguration().clone());
        clone.setArchiverConfiguration(this.getArchiverConfiguration().clone());
        clone.setPackagingConfiguration(this.getPackagingConfiguration().clone());
        clone.setRequiredProjectsConfiguration(this.getRequiredProjectsConfiguration().clone());
        clone.setDebuggerChooserConfiguration(this.getDebuggerChooserConfiguration().clone());
        clone.setQmakeConfiguration(this.getQmakeConfiguration().clone());
        dhconf.addPropertyChangeListener(csconf);
        ConfigurationAuxObject[] objects = this.getAuxObjects();
        ArrayList<ConfigurationAuxObject> clonedAuxObjects = new ArrayList<ConfigurationAuxObject>();
        for (int i = 0; i < objects.length; ++i) {
            clonedAuxObjects.add(objects[i].clone(this));
        }
        clone.setAuxObjects(clonedAuxObjects);
        return clone;
    }

    public Sheet getBuildSheet(Project project) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("ProjectDefaults");
        set.setDisplayName(MakeConfiguration.getString("ProjectDefaultsTxt"));
        set.setShortDescription(MakeConfiguration.getString("ProjectDefaultsHint"));
        set.put((Node.Property)new DevelopmentHostNodeProp(this.getDevelopmentHost(), true, MakeConfiguration.getString("DevelopmentHostTxt"), MakeConfiguration.getString("DevelopmentHostHint")));
        set.put((Node.Property)new CompilerSetNodeProp(this.getCompilerSet(), this.getDevelopmentHost(), true, "CompilerSCollection2", MakeConfiguration.getString("CompilerCollectionTxt"), MakeConfiguration.getString("CompilerCollectionHint")));
        set.put((Node.Property)new IntNodeProp(this.getConfigurationType(), true, "ConfigurationType", MakeConfiguration.getString("ConfigurationTypeTxt"), MakeConfiguration.getString("ConfigurationTypeHint")));
        sheet.put(set);
        if (this.isCompileConfiguration()) {
            set = Sheet.createExpertSet();
            set.put((Node.Property)new BooleanNodeProp(this.getDependencyChecking(), true, "DependencyChecking", MakeConfiguration.getString("DependencyCheckingTxt"), MakeConfiguration.getString("DependencyCheckingHint")));
            set.put((Node.Property)new BooleanNodeProp(this.getRebuildPropChanged(), true, "RebuildPropChanged", MakeConfiguration.getString("RebuildPropChangedTxt"), MakeConfiguration.getString("RebuildPropChangedHint")));
            sheet.put(set);
        }
        return sheet;
    }

    public Sheet getRequiredProjectsSheet(Project project, MakeConfiguration conf) {
        Sheet sheet = new Sheet();
        String[] texts = new String[]{MakeConfiguration.getString("ProjectsTxt1"), MakeConfiguration.getString("ProjectsHint"), MakeConfiguration.getString("ProjectsTxt2"), MakeConfiguration.getString("AllOptionsTxt2")};
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("Projects");
        set2.setDisplayName(MakeConfiguration.getString("ProjectsTxt1"));
        set2.setShortDescription(MakeConfiguration.getString("ProjectsHint"));
        set2.put((Node.Property)new RequiredProjectsNodeProp(this.getRequiredProjectsConfiguration(), project, conf, this.getBaseDir(), texts));
        sheet.put(set2);
        return sheet;
    }

    public void setRequiredLanguagesDirty(boolean b) {
        this.languagesDirty = b;
    }

    public boolean getRequiredLanguagesDirty() {
        return this.languagesDirty;
    }

    public boolean hasCFiles(MakeConfigurationDescriptor configurationDescriptor) {
        this.reCountLanguages(configurationDescriptor);
        return this.cRequired.getValue();
    }

    public boolean hasCPPFiles(MakeConfigurationDescriptor configurationDescriptor) {
        this.reCountLanguages(configurationDescriptor);
        return this.cppRequired.getValue();
    }

    public boolean hasFortranFiles(MakeConfigurationDescriptor configurationDescriptor) {
        this.reCountLanguages(configurationDescriptor);
        return this.fortranRequired.getValue();
    }

    public boolean hasAssemblerFiles(MakeConfigurationDescriptor configurationDescriptor) {
        this.reCountLanguages(configurationDescriptor);
        return this.assemblerRequired.getValue();
    }

    public void reCountLanguages(MakeConfigurationDescriptor configurationDescriptor) {
        boolean hasCFiles = false;
        boolean hasCPPFiles = false;
        boolean hasFortranFiles = false;
        boolean hasAssemblerFiles = false;
        if (!this.getRequiredLanguagesDirty()) {
            return;
        }
        Item[] items = configurationDescriptor.getProjectItems();
        if (items.length == 0 && this.isMakefileConfiguration()) {
            hasCFiles = true;
            hasCPPFiles = true;
        } else {
            for (int x = 0; x < items.length; ++x) {
                ItemConfiguration itemConfiguration = items[x].getItemConfiguration(this);
                if (itemConfiguration == null || itemConfiguration.getExcluded() == null || itemConfiguration.getExcluded().getValue()) continue;
                if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                    hasCFiles = true;
                }
                if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                    hasCPPFiles = true;
                }
                if (itemConfiguration.getTool() == PredefinedToolKind.FortranCompiler) {
                    hasFortranFiles = true;
                }
                if (itemConfiguration.getTool() != PredefinedToolKind.Assembler) continue;
                hasAssemblerFiles = true;
            }
        }
        this.cRequired.setDefault(hasCFiles);
        this.cppRequired.setDefault(hasCPPFiles);
        this.fortranRequired.setDefault(hasFortranFiles);
        this.assemblerRequired.setDefault(hasAssemblerFiles);
        this.languagesDirty = false;
    }

    public String getVariant() {
        String ret = "";
        if (this.getCompilerSet().getCompilerSet() == null) {
            return ret;
        }
        return MakeConfiguration.getVariant(this.getCompilerSet().getCompilerSet(), this.getDevelopmentHost().getBuildPlatform());
    }

    public static String getVariant(CompilerSet compilerSet, int platform) {
        return compilerSet.getName() + "-" + Platforms.getPlatform(platform).getName();
    }

    public Set<Project> getSubProjects() {
        HashSet<Project> subProjects = new HashSet<Project>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        for (LibraryItem item : librariesConfiguration.getValue()) {
            LibraryItem.ProjectItem projectItem;
            Project project;
            if (!(item instanceof LibraryItem.ProjectItem) || (project = (projectItem = (LibraryItem.ProjectItem)item).getProject(this.getBaseDir())) == null) continue;
            subProjects.add(project);
        }
        for (LibraryItem.ProjectItem libProject : this.getRequiredProjectsConfiguration().getValue()) {
            Project project = libProject.getProject(this.getBaseDir());
            if (project == null) continue;
            subProjects.add(project);
        }
        return subProjects;
    }

    public Set<String> getSubProjectLocations() {
        HashSet<String> subProjectLocations = new HashSet<String>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        for (LibraryItem item : librariesConfiguration.getValue()) {
            if (!(item instanceof LibraryItem.ProjectItem)) continue;
            LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)item;
            subProjectLocations.add(projectItem.getMakeArtifact().getProjectLocation());
        }
        return subProjectLocations;
    }

    public Set<String> getSubProjectOutputLocations() {
        HashSet<String> subProjectOutputLocations = new HashSet<String>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        for (LibraryItem item : librariesConfiguration.getValue()) {
            if (!(item instanceof LibraryItem.ProjectItem)) continue;
            LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)item;
            String outputLocation = CndPathUtilitities.getDirName((String)projectItem.getMakeArtifact().getOutput());
            if (CndPathUtilitities.isPathAbsolute((String)outputLocation)) {
                subProjectOutputLocations.add(outputLocation);
                continue;
            }
            subProjectOutputLocations.add(projectItem.getMakeArtifact().getProjectLocation() + "/" + outputLocation);
        }
        return subProjectOutputLocations;
    }

    public String getOutputValue() {
        String output = null;
        if (this.isLinkerConfiguration()) {
            output = this.getLinkerConfiguration().getOutputValue();
        } else if (this.isArchiverConfiguration()) {
            output = this.getArchiverConfiguration().getOutputValue();
        } else if (this.isMakefileConfiguration()) {
            output = this.getMakefileConfiguration().getOutput().getValue();
        } else if (this.isQmakeConfiguration()) {
            output = this.getQmakeConfiguration().getOutputValue();
        } else assert (false);
        return output;
    }

    public String getAbsoluteOutputValue() {
        String output = this.getOutputValue();
        if (output == null) {
            return output;
        }
        if (!CndPathUtilitities.isPathAbsolute((String)output)) {
            output = this.getBaseDir() + "/" + output;
            output = CndPathUtilitities.normalize((String)output);
        }
        return this.expandMacros(output);
    }

    public boolean hasDebugger() {
        return ProjectActionSupport.getInstance().canHandle(this, ProjectActionEvent.PredefinedType.DEBUG);
    }

    public String expandMacros(String val) {
        val = CndPathUtilitities.expandMacro((String)val, (String)"${TESTDIR}", (String)"build/${CND_CONF}/${CND_PLATFORM}/tests");
        val = CndPathUtilitities.expandMacro((String)val, (String)"${OUTPUT_PATH}", (String)this.getOutputValue());
        val = CndPathUtilitities.expandMacro((String)val, (String)"${OUTPUT_BASENAME}", (String)CndPathUtilitities.getBaseName((String)this.getOutputValue()));
        val = CndPathUtilitities.expandMacro((String)val, (String)"${PLATFORM}", (String)this.getVariant());
        val = CndPathUtilitities.expandMacro((String)val, (String)"${CND_PLATFORM}", (String)this.getVariant());
        val = CndPathUtilitities.expandMacro((String)val, (String)"${CND_CONF}", (String)this.getName());
        val = CndPathUtilitities.expandMacro((String)val, (String)"${CND_DISTDIR}", (String)DIST_FOLDER);
        return val;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeConfiguration.class, (String)s);
    }

    private static final class ManagedIntConfiguration
    extends IntConfiguration {
        public ManagedIntConfiguration(IntConfiguration master, int def, String[] names, String[] options) {
            super(master, def, names, options);
        }

        @Override
        public void setValue(String s) {
            String[] names = this.getNames();
            if (s != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (!s.equals(names[i])) continue;
                    this.setValue(i + 1);
                    break;
                }
            }
        }

        @Override
        public String getName() {
            return this.getNames()[this.getValue() - 1];
        }
    }

    public class LanguageBooleanConfiguration
    extends BooleanConfiguration {
        private boolean notYetSet;

        LanguageBooleanConfiguration() {
            super(false);
            this.notYetSet = true;
        }

        @Override
        public void setValue(boolean b) {
            if (this.notYetSet) {
                this.setValue(b, b);
            } else {
                super.setValue(b);
            }
            this.notYetSet = false;
        }

        @Override
        public void setDefault(boolean b) {
            if (this.getValue() == this.getDefault()) {
                this.setValue(b, b);
            } else {
                super.setDefault(b);
            }
            this.notYetSet = false;
        }

        public void setValue(boolean v, boolean d) {
            super.setValue(v);
            super.setDefault(d);
            this.notYetSet = false;
        }

        @Override
        public LanguageBooleanConfiguration clone() {
            LanguageBooleanConfiguration clone = new LanguageBooleanConfiguration();
            clone.setValue(this.getValue(), this.getDefault());
            clone.setModified(this.getModified());
            return clone;
        }

        public void assign(LanguageBooleanConfiguration conf) {
            this.setValue(conf.getValue(), conf.getDefault());
            this.setModified(conf.getModified());
        }
    }
}

