/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.JBDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.ResourceConfigurationHelper;
import org.netbeans.modules.j2ee.jboss4.config.gen.EjbRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossClient;
import org.netbeans.modules.j2ee.jboss4.config.gen.ResourceRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.ServiceRef;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CarDeploymentConfiguration
extends JBDeploymentConfiguration
implements ModuleConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private File jbossClientFile;
    private JbossClient jbossClient;

    public CarDeploymentConfiguration(J2eeModule j2eeModule) {
        super(j2eeModule);
        this.jbossClientFile = j2eeModule.getDeploymentConfigurationFile("META-INF/jboss-client.xml");
        this.getJbossClient();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossClientFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
    }

    public void dispose() {
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public synchronized JbossClient getJbossClient() {
        if (this.jbossClient == null) {
            try {
                if (this.jbossClientFile.exists()) {
                    try {
                        this.jbossClient = JbossClient.createGraph(this.jbossClientFile);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                } else {
                    this.jbossClient = this.generateJbossClient();
                    ResourceConfigurationHelper.writeFile(this.jbossClientFile, this.jbossClient);
                }
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.jbossClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getPropertyName() == "modified" && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
            if (propertyChangeEvent.getSource() == this.deploymentDescriptorDO) {
                CarDeploymentConfiguration carDeploymentConfiguration = this;
                synchronized (carDeploymentConfiguration) {
                    this.jbossClient = null;
                }
            }
        } else if (propertyChangeEvent.getOldValue() == null) {
            if (object instanceof org.netbeans.modules.j2ee.dd.api.common.ResourceRef) {
                org.netbeans.modules.j2ee.dd.api.common.ResourceRef resourceRef = (org.netbeans.modules.j2ee.dd.api.common.ResourceRef)object;
                try {
                    String string = resourceRef.getResType();
                    if ("javax.sql.DataSource".equals(string)) {
                        this.addResReference(resourceRef.getResRefName());
                    } else if ("javax.mail.Session".equals(string)) {
                        this.addMailReference(resourceRef.getResRefName());
                    } else if ("javax.jms.ConnectionFactory".equals(string)) {
                        this.addConnectionFactoryReference(resourceRef.getResRefName());
                    }
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            } else if (object instanceof org.netbeans.modules.j2ee.dd.api.common.EjbRef) {
                org.netbeans.modules.j2ee.dd.api.common.EjbRef ejbRef = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)object;
                try {
                    String string = ejbRef.getEjbRefType();
                    if ("Session".equals(string) || "Entity".equals(string)) {
                        this.addEjbReference(ejbRef.getEjbRefName());
                    }
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            } else if (object instanceof org.netbeans.modules.j2ee.dd.api.common.ServiceRef) {
                org.netbeans.modules.j2ee.dd.api.common.ServiceRef serviceRef = (org.netbeans.modules.j2ee.dd.api.common.ServiceRef)object;
                try {
                    this.addServiceReference(serviceRef.getServiceRefName());
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            }
        }
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        JbossClient jbossClient = this.getJbossClient();
        if (jbossClient == null) {
            String string = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.jbossClientFile.getAbsolutePath());
            throw new ConfigurationException(string);
        }
        try {
            jbossClient.write(outputStream);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossClientFile.getAbsolutePath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private JbossClient generateJbossClient() {
        JbossClient jbossClient = new JbossClient();
        return jbossClient;
    }

    private void addResReference(final String string) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            @Override
            public void modify(JbossClient jbossClient) {
                ResourceRef[] resourceRefArray = jbossClient.getResourceRef();
                for (int i = 0; i < resourceRefArray.length; ++i) {
                    String string2 = resourceRefArray[i].getResRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                ResourceRef resourceRef = new ResourceRef();
                resourceRef.setResRefName(string);
                resourceRef.setJndiName("java:/" + string);
                jbossClient.addResourceRef(resourceRef);
            }
        });
    }

    private void addMailReference(final String string) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            @Override
            public void modify(JbossClient jbossClient) {
                ResourceRef[] resourceRefArray = jbossClient.getResourceRef();
                for (int i = 0; i < resourceRefArray.length; ++i) {
                    String string2 = resourceRefArray[i].getResRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                ResourceRef resourceRef = new ResourceRef();
                resourceRef.setResRefName(string);
                resourceRef.setJndiName("java:Mail");
                jbossClient.addResourceRef(resourceRef);
            }
        });
    }

    private void addConnectionFactoryReference(final String string) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            @Override
            public void modify(JbossClient jbossClient) {
                ResourceRef[] resourceRefArray = jbossClient.getResourceRef();
                for (int i = 0; i < resourceRefArray.length; ++i) {
                    String string2 = resourceRefArray[i].getResRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                ResourceRef resourceRef = new ResourceRef();
                resourceRef.setResRefName(string);
                resourceRef.setJndiName("ConnectionFactory");
                jbossClient.addResourceRef(resourceRef);
            }
        });
    }

    private void addEjbReference(final String string) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            @Override
            public void modify(JbossClient jbossClient) {
                EjbRef[] ejbRefArray = jbossClient.getEjbRef();
                for (int i = 0; i < ejbRefArray.length; ++i) {
                    String string2 = ejbRefArray[i].getEjbRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                EjbRef ejbRef = new EjbRef();
                ejbRef.setEjbRefName(string);
                ejbRef.setJndiName(string);
                jbossClient.addEjbRef(ejbRef);
            }
        });
    }

    private void setJndiName(final String string) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            @Override
            public void modify(JbossClient jbossClient) {
                jbossClient.setJndiName(string);
            }
        });
    }

    private void addServiceReference(final String string) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){

            @Override
            public void modify(JbossClient jbossClient) {
                ServiceRef[] serviceRefArray = jbossClient.getServiceRef();
                for (int i = 0; i < serviceRefArray.length; ++i) {
                    String string2 = serviceRefArray[i].getServiceRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                ServiceRef serviceRef = new ServiceRef();
                serviceRef.setServiceRefName(string);
                jbossClient.addServiceRef(serviceRef);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyJbossClient(JbossClientModifier jbossClientModifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            Object object;
            EditorCookie editorCookie = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument == null) {
                styledDocument = editorCookie.openDocument();
            }
            JbossClient jbossClient = null;
            try {
                byte[] byArray = styledDocument.getText(0, styledDocument.getLength()).getBytes();
                jbossClient = JbossClient.createGraph(new ByteArrayInputStream(byArray));
            }
            catch (RuntimeException runtimeException) {
                object = this.getJbossClient();
                if (object == null) {
                    String string = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)this.jbossClientFile.getAbsolutePath());
                    throw new ConfigurationException(string);
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_jbossClientXmlNotValid"), 2);
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object2 == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                jbossClient = object;
            }
            jbossClientModifier.modify(jbossClient);
            boolean bl = this.deploymentDescriptorDO.isModified();
            ResourceConfigurationHelper.replaceDocument(styledDocument, jbossClient);
            if (!bl && (object = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class)) != null) {
                object.save();
            }
            object = this;
            synchronized (object) {
                this.jbossClient = jbossClient;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossClientFile.getAbsolutePath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    public boolean supportsCreateDatasource() {
        return true;
    }

    public boolean supportsCreateMessageDestination() {
        return false;
    }

    private static interface JbossClientModifier {
        public void modify(JbossClient var1);
    }
}

