/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.security.acl.NotOwnerException;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.sps.impl.FetchPrivilegesTask;
import org.netbeans.modules.nativeexecution.sps.impl.RequestPrivilegesAction;
import org.netbeans.modules.nativeexecution.sps.impl.RequestPrivilegesTask;
import org.netbeans.modules.nativeexecution.support.ObservableActionListener;
import org.netbeans.modules.nativeexecution.support.TasksCachedProcessor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public abstract class SPSCommonImpl
implements SolarisPrivilegesSupport {
    private static final TasksCachedProcessor<ExecutionEnvironment, List<String>> cachedPrivilegesFetcher = new TasksCachedProcessor<ExecutionEnvironment, List<String>>(new FetchPrivilegesTask(), false);
    private static final TasksCachedProcessor<RequestPrivilegesTask.RequestPrivilegesTaskParams, Boolean> cachedPrivilegesRequestor = new TasksCachedProcessor<RequestPrivilegesTask.RequestPrivilegesTaskParams, Boolean>(new RequestPrivilegesTask(), true);
    private final ExecutionEnvironment execEnv;
    private volatile boolean cancelled = false;
    private final ConnectionListener connectionListener;

    protected SPSCommonImpl(final ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
        this.connectionListener = new ConnectionListener(){

            @Override
            public void connected(ExecutionEnvironment env) {
            }

            @Override
            public void disconnected(ExecutionEnvironment env) {
                if (((Object)execEnv).equals(env)) {
                    SPSCommonImpl.this.invalidate();
                }
            }
        };
        ConnectionManager cm = ConnectionManager.getInstance();
        cm.addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this.connectionListener, (Object)cm));
    }

    ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    abstract String getPID();

    @Override
    public abstract void requestPrivileges(Collection<String> var1, String var2, char[] var3) throws NotOwnerException, CancellationException;

    @Override
    public void requestPrivileges(Collection<String> requestedPrivileges, boolean askForPassword) throws NotOwnerException, CancellationException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("requestExecutionPrivileges should never be called in AWT thread");
        }
        if (askForPassword && this.cancelled) {
            return;
        }
        if (this.hasPrivileges(requestedPrivileges)) {
            return;
        }
        try {
            if (!cachedPrivilegesRequestor.compute(new RequestPrivilegesTask.RequestPrivilegesTaskParams(this, requestedPrivileges, askForPassword)).booleanValue()) {
                throw new NotOwnerException();
            }
            this.invalidateCache();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public boolean hasPrivileges(Collection<String> privs) {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            this.invalidate();
            return false;
        }
        List<String> real_privs = this.getExecutionPrivileges();
        if (real_privs == null) {
            return false;
        }
        boolean status = true;
        for (String priv : privs) {
            if (!status) break;
            status &= real_privs.contains(priv);
        }
        return status;
    }

    @Override
    public List<String> getExecutionPrivileges() {
        List<String> result = null;
        try {
            result = cachedPrivilegesFetcher.compute(this.execEnv);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public AsynchronousAction getRequestPrivilegesAction(Collection<String> requestedPrivileges, final Runnable onPrivilegesGranted) {
        RequestPrivilegesAction action = RequestPrivilegesAction.getInstance(this, requestedPrivileges);
        if (onPrivilegesGranted != null) {
            action.addObservableActionListener(new ObservableActionListener<Boolean>(){

                @Override
                public void actionStarted(Action source) {
                }

                @Override
                public void actionCompleted(Action source, Boolean result) {
                    if (result != null && result.booleanValue()) {
                        onPrivilegesGranted.run();
                    }
                }
            });
        }
        return action;
    }

    private void invalidateCache() {
        cachedPrivilegesFetcher.remove(this.execEnv);
    }

    @Override
    public void invalidate() {
        this.invalidateCache();
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(SPSCommonImpl.class, (String)key, (Object[])params);
    }
}

